package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ComponentStatusListBuilder extends ComponentStatusListFluent<ComponentStatusListBuilder> implements VisitableBuilder<ComponentStatusList,ComponentStatusListBuilder>{
  public ComponentStatusListBuilder() {
    this(new ComponentStatusList());
  }
  
  public ComponentStatusListBuilder(ComponentStatusListFluent<?> fluent) {
    this(fluent, new ComponentStatusList());
  }
  
  public ComponentStatusListBuilder(ComponentStatusListFluent<?> fluent,ComponentStatusList instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ComponentStatusListBuilder(ComponentStatusList instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ComponentStatusListFluent<?> fluent;
  
  public ComponentStatusList build() {
    ComponentStatusList buildable = new ComponentStatusList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.buildMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}