/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ContainerState;
import io.fabric8.kubernetes.api.model.ContainerStateBuilder;
import io.fabric8.kubernetes.api.model.ContainerStateFluent;
import io.fabric8.kubernetes.api.model.ContainerStatus;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ContainerStatusFluent<A extends ContainerStatusFluent<A>>
extends BaseFluent<A> {
    private Map<String, Quantity> allocatedResources;
    private String containerID;
    private String image;
    private String imageID;
    private ContainerStateBuilder lastState;
    private String name;
    private Boolean ready;
    private ResourceRequirementsBuilder resources;
    private Integer restartCount;
    private Boolean started;
    private ContainerStateBuilder state;
    private Map<String, Object> additionalProperties;

    public ContainerStatusFluent() {
    }

    public ContainerStatusFluent(ContainerStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ContainerStatus instance) {
        ContainerStatus containerStatus = instance = instance != null ? instance : new ContainerStatus();
        if (instance != null) {
            this.withAllocatedResources(instance.getAllocatedResources());
            this.withContainerID(instance.getContainerID());
            this.withImage(instance.getImage());
            this.withImageID(instance.getImageID());
            this.withLastState(instance.getLastState());
            this.withName(instance.getName());
            this.withReady(instance.getReady());
            this.withResources(instance.getResources());
            this.withRestartCount(instance.getRestartCount());
            this.withStarted(instance.getStarted());
            this.withState(instance.getState());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToAllocatedResources(String key, Quantity value) {
        if (this.allocatedResources == null && key != null && value != null) {
            this.allocatedResources = new LinkedHashMap<String, Quantity>();
        }
        if (key != null && value != null) {
            this.allocatedResources.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAllocatedResources(Map<String, Quantity> map) {
        if (this.allocatedResources == null && map != null) {
            this.allocatedResources = new LinkedHashMap<String, Quantity>();
        }
        if (map != null) {
            this.allocatedResources.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAllocatedResources(String key) {
        if (this.allocatedResources == null) {
            return (A)((Object)this);
        }
        if (key != null && this.allocatedResources != null) {
            this.allocatedResources.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAllocatedResources(Map<String, Quantity> map) {
        if (this.allocatedResources == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.allocatedResources == null) continue;
                this.allocatedResources.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Quantity> getAllocatedResources() {
        return this.allocatedResources;
    }

    public <K, V> A withAllocatedResources(Map<String, Quantity> allocatedResources) {
        this.allocatedResources = allocatedResources == null ? null : new LinkedHashMap<String, Quantity>(allocatedResources);
        return (A)((Object)this);
    }

    public boolean hasAllocatedResources() {
        return this.allocatedResources != null;
    }

    public String getContainerID() {
        return this.containerID;
    }

    public A withContainerID(String containerID) {
        this.containerID = containerID;
        return (A)((Object)this);
    }

    public boolean hasContainerID() {
        return this.containerID != null;
    }

    public String getImage() {
        return this.image;
    }

    public A withImage(String image) {
        this.image = image;
        return (A)((Object)this);
    }

    public boolean hasImage() {
        return this.image != null;
    }

    public String getImageID() {
        return this.imageID;
    }

    public A withImageID(String imageID) {
        this.imageID = imageID;
        return (A)((Object)this);
    }

    public boolean hasImageID() {
        return this.imageID != null;
    }

    public ContainerState buildLastState() {
        return this.lastState != null ? this.lastState.build() : null;
    }

    public A withLastState(ContainerState lastState) {
        this._visitables.remove((Object)"lastState");
        if (lastState != null) {
            this.lastState = new ContainerStateBuilder(lastState);
            this._visitables.get((Object)"lastState").add(this.lastState);
        } else {
            this.lastState = null;
            this._visitables.get((Object)"lastState").remove((Object)this.lastState);
        }
        return (A)((Object)this);
    }

    public boolean hasLastState() {
        return this.lastState != null;
    }

    public LastStateNested<A> withNewLastState() {
        return new LastStateNested(null);
    }

    public LastStateNested<A> withNewLastStateLike(ContainerState item) {
        return new LastStateNested(item);
    }

    public LastStateNested<A> editLastState() {
        return this.withNewLastStateLike(Optional.ofNullable(this.buildLastState()).orElse(null));
    }

    public LastStateNested<A> editOrNewLastState() {
        return this.withNewLastStateLike(Optional.ofNullable(this.buildLastState()).orElse(new ContainerStateBuilder().build()));
    }

    public LastStateNested<A> editOrNewLastStateLike(ContainerState item) {
        return this.withNewLastStateLike(Optional.ofNullable(this.buildLastState()).orElse(item));
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)((Object)this);
    }

    public boolean hasName() {
        return this.name != null;
    }

    public Boolean getReady() {
        return this.ready;
    }

    public A withReady(Boolean ready) {
        this.ready = ready;
        return (A)((Object)this);
    }

    public boolean hasReady() {
        return this.ready != null;
    }

    public ResourceRequirements buildResources() {
        return this.resources != null ? this.resources.build() : null;
    }

    public A withResources(ResourceRequirements resources) {
        this._visitables.remove((Object)"resources");
        if (resources != null) {
            this.resources = new ResourceRequirementsBuilder(resources);
            this._visitables.get((Object)"resources").add(this.resources);
        } else {
            this.resources = null;
            this._visitables.get((Object)"resources").remove((Object)this.resources);
        }
        return (A)((Object)this);
    }

    public boolean hasResources() {
        return this.resources != null;
    }

    public ResourcesNested<A> withNewResources() {
        return new ResourcesNested(null);
    }

    public ResourcesNested<A> withNewResourcesLike(ResourceRequirements item) {
        return new ResourcesNested(item);
    }

    public ResourcesNested<A> editResources() {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(null));
    }

    public ResourcesNested<A> editOrNewResources() {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(new ResourceRequirementsBuilder().build()));
    }

    public ResourcesNested<A> editOrNewResourcesLike(ResourceRequirements item) {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(item));
    }

    public Integer getRestartCount() {
        return this.restartCount;
    }

    public A withRestartCount(Integer restartCount) {
        this.restartCount = restartCount;
        return (A)((Object)this);
    }

    public boolean hasRestartCount() {
        return this.restartCount != null;
    }

    public Boolean getStarted() {
        return this.started;
    }

    public A withStarted(Boolean started) {
        this.started = started;
        return (A)((Object)this);
    }

    public boolean hasStarted() {
        return this.started != null;
    }

    public ContainerState buildState() {
        return this.state != null ? this.state.build() : null;
    }

    public A withState(ContainerState state) {
        this._visitables.remove((Object)"state");
        if (state != null) {
            this.state = new ContainerStateBuilder(state);
            this._visitables.get((Object)"state").add(this.state);
        } else {
            this.state = null;
            this._visitables.get((Object)"state").remove((Object)this.state);
        }
        return (A)((Object)this);
    }

    public boolean hasState() {
        return this.state != null;
    }

    public StateNested<A> withNewState() {
        return new StateNested(null);
    }

    public StateNested<A> withNewStateLike(ContainerState item) {
        return new StateNested(item);
    }

    public StateNested<A> editState() {
        return this.withNewStateLike(Optional.ofNullable(this.buildState()).orElse(null));
    }

    public StateNested<A> editOrNewState() {
        return this.withNewStateLike(Optional.ofNullable(this.buildState()).orElse(new ContainerStateBuilder().build()));
    }

    public StateNested<A> editOrNewStateLike(ContainerState item) {
        return this.withNewStateLike(Optional.ofNullable(this.buildState()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ContainerStatusFluent that = (ContainerStatusFluent)((Object)o);
        if (!Objects.equals(this.allocatedResources, that.allocatedResources)) {
            return false;
        }
        if (!Objects.equals(this.containerID, that.containerID)) {
            return false;
        }
        if (!Objects.equals(this.image, that.image)) {
            return false;
        }
        if (!Objects.equals(this.imageID, that.imageID)) {
            return false;
        }
        if (!Objects.equals((Object)this.lastState, (Object)that.lastState)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.ready, that.ready)) {
            return false;
        }
        if (!Objects.equals((Object)this.resources, (Object)that.resources)) {
            return false;
        }
        if (!Objects.equals(this.restartCount, that.restartCount)) {
            return false;
        }
        if (!Objects.equals(this.started, that.started)) {
            return false;
        }
        if (!Objects.equals((Object)this.state, (Object)that.state)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.allocatedResources, this.containerID, this.image, this.imageID, this.lastState, this.name, this.ready, this.resources, this.restartCount, this.started, this.state, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.allocatedResources != null && !this.allocatedResources.isEmpty()) {
            sb.append("allocatedResources:");
            sb.append(this.allocatedResources + ",");
        }
        if (this.containerID != null) {
            sb.append("containerID:");
            sb.append(this.containerID + ",");
        }
        if (this.image != null) {
            sb.append("image:");
            sb.append(this.image + ",");
        }
        if (this.imageID != null) {
            sb.append("imageID:");
            sb.append(this.imageID + ",");
        }
        if (this.lastState != null) {
            sb.append("lastState:");
            sb.append((Object)((Object)this.lastState) + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.ready != null) {
            sb.append("ready:");
            sb.append(this.ready + ",");
        }
        if (this.resources != null) {
            sb.append("resources:");
            sb.append((Object)((Object)this.resources) + ",");
        }
        if (this.restartCount != null) {
            sb.append("restartCount:");
            sb.append(this.restartCount + ",");
        }
        if (this.started != null) {
            sb.append("started:");
            sb.append(this.started + ",");
        }
        if (this.state != null) {
            sb.append("state:");
            sb.append((Object)((Object)this.state) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withReady() {
        return this.withReady(true);
    }

    public A withStarted() {
        return this.withStarted(true);
    }

    public class StateNested<N>
    extends ContainerStateFluent<StateNested<N>>
    implements Nested<N> {
        ContainerStateBuilder builder;

        StateNested(ContainerState item) {
            this.builder = new ContainerStateBuilder(this, item);
        }

        public N and() {
            return (N)ContainerStatusFluent.this.withState(this.builder.build());
        }

        public N endState() {
            return this.and();
        }
    }

    public class ResourcesNested<N>
    extends ResourceRequirementsFluent<ResourcesNested<N>>
    implements Nested<N> {
        ResourceRequirementsBuilder builder;

        ResourcesNested(ResourceRequirements item) {
            this.builder = new ResourceRequirementsBuilder(this, item);
        }

        public N and() {
            return (N)ContainerStatusFluent.this.withResources(this.builder.build());
        }

        public N endResources() {
            return this.and();
        }
    }

    public class LastStateNested<N>
    extends ContainerStateFluent<LastStateNested<N>>
    implements Nested<N> {
        ContainerStateBuilder builder;

        LastStateNested(ContainerState item) {
            this.builder = new ContainerStateBuilder(this, item);
        }

        public N and() {
            return (N)ContainerStatusFluent.this.withLastState(this.builder.build());
        }

        public N endLastState() {
            return this.and();
        }
    }
}

