package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class APIServiceBuilder extends APIServiceFluent<APIServiceBuilder> implements VisitableBuilder<APIService,APIServiceBuilder>{
  public APIServiceBuilder() {
    this(new APIService());
  }
  
  public APIServiceBuilder(APIServiceFluent<?> fluent) {
    this(fluent, new APIService());
  }
  
  public APIServiceBuilder(APIServiceFluent<?> fluent,APIService instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public APIServiceBuilder(APIService instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  APIServiceFluent<?> fluent;
  
  public APIService build() {
    APIService buildable = new APIService(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}