package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class EnvVarSourceBuilder extends EnvVarSourceFluent<EnvVarSourceBuilder> implements VisitableBuilder<EnvVarSource,EnvVarSourceBuilder>{
  public EnvVarSourceBuilder() {
    this(new EnvVarSource());
  }
  
  public EnvVarSourceBuilder(EnvVarSourceFluent<?> fluent) {
    this(fluent, new EnvVarSource());
  }
  
  public EnvVarSourceBuilder(EnvVarSourceFluent<?> fluent,EnvVarSource instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public EnvVarSourceBuilder(EnvVarSource instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  EnvVarSourceFluent<?> fluent;
  
  public EnvVarSource build() {
    EnvVarSource buildable = new EnvVarSource(fluent.buildConfigMapKeyRef(),fluent.buildFieldRef(),fluent.buildResourceFieldRef(),fluent.buildSecretKeyRef());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}