package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class SecretEnvSourceBuilder extends SecretEnvSourceFluent<SecretEnvSourceBuilder> implements VisitableBuilder<SecretEnvSource,SecretEnvSourceBuilder>{
  public SecretEnvSourceBuilder() {
    this(new SecretEnvSource());
  }
  
  public SecretEnvSourceBuilder(SecretEnvSourceFluent<?> fluent) {
    this(fluent, new SecretEnvSource());
  }
  
  public SecretEnvSourceBuilder(SecretEnvSourceFluent<?> fluent,SecretEnvSource instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public SecretEnvSourceBuilder(SecretEnvSource instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  SecretEnvSourceFluent<?> fluent;
  
  public SecretEnvSource build() {
    SecretEnvSource buildable = new SecretEnvSource(fluent.getName(),fluent.getOptional());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}