package io.fabric8.kubernetes.api.model.clusterapi.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class MachineSpecBuilder extends MachineSpecFluent<MachineSpecBuilder> implements VisitableBuilder<MachineSpec,MachineSpecBuilder>{
  public MachineSpecBuilder() {
    this(new MachineSpec());
  }
  
  public MachineSpecBuilder(MachineSpecFluent<?> fluent) {
    this(fluent, new MachineSpec());
  }
  
  public MachineSpecBuilder(MachineSpecFluent<?> fluent,MachineSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public MachineSpecBuilder(MachineSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  MachineSpecFluent<?> fluent;
  
  public MachineSpec build() {
    MachineSpec buildable = new MachineSpec(fluent.buildBootstrap(),fluent.getClusterName(),fluent.getFailureDomain(),fluent.buildInfrastructureRef(),fluent.getNodeDeletionTimeout(),fluent.getNodeDrainTimeout(),fluent.getNodeVolumeDetachTimeout(),fluent.getProviderID(),fluent.getVersion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}