package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ReplicationControllerStatusBuilder extends ReplicationControllerStatusFluent<ReplicationControllerStatusBuilder> implements VisitableBuilder<ReplicationControllerStatus,ReplicationControllerStatusBuilder>{
  public ReplicationControllerStatusBuilder() {
    this(new ReplicationControllerStatus());
  }
  
  public ReplicationControllerStatusBuilder(ReplicationControllerStatusFluent<?> fluent) {
    this(fluent, new ReplicationControllerStatus());
  }
  
  public ReplicationControllerStatusBuilder(ReplicationControllerStatusFluent<?> fluent,ReplicationControllerStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ReplicationControllerStatusBuilder(ReplicationControllerStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ReplicationControllerStatusFluent<?> fluent;
  
  public ReplicationControllerStatus build() {
    ReplicationControllerStatus buildable = new ReplicationControllerStatus(fluent.getAvailableReplicas(),fluent.buildConditions(),fluent.getFullyLabeledReplicas(),fluent.getObservedGeneration(),fluent.getReadyReplicas(),fluent.getReplicas());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}