package io.fabric8.kubernetes.api.model.clusterapi.v1beta1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Duration;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class MachineSpecFluent<A extends MachineSpecFluent<A>> extends BaseFluent<A>{
  public MachineSpecFluent() {
  }
  
  public MachineSpecFluent(MachineSpec instance) {
    this.copyInstance(instance);
  }
  private BootstrapBuilder bootstrap;
  private String clusterName;
  private String failureDomain;
  private ObjectReferenceBuilder infrastructureRef;
  private Duration nodeDeletionTimeout;
  private Duration nodeDrainTimeout;
  private Duration nodeVolumeDetachTimeout;
  private String providerID;
  private String version;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(MachineSpec instance) {
    instance = (instance != null ? instance : new MachineSpec());
    if (instance != null) {
          this.withBootstrap(instance.getBootstrap());
          this.withClusterName(instance.getClusterName());
          this.withFailureDomain(instance.getFailureDomain());
          this.withInfrastructureRef(instance.getInfrastructureRef());
          this.withNodeDeletionTimeout(instance.getNodeDeletionTimeout());
          this.withNodeDrainTimeout(instance.getNodeDrainTimeout());
          this.withNodeVolumeDetachTimeout(instance.getNodeVolumeDetachTimeout());
          this.withProviderID(instance.getProviderID());
          this.withVersion(instance.getVersion());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public Bootstrap buildBootstrap() {
    return this.bootstrap != null ? this.bootstrap.build() : null;
  }
  
  public A withBootstrap(Bootstrap bootstrap) {
    this._visitables.remove("bootstrap");
    if (bootstrap != null) {
        this.bootstrap = new BootstrapBuilder(bootstrap);
        this._visitables.get("bootstrap").add(this.bootstrap);
    } else {
        this.bootstrap = null;
        this._visitables.get("bootstrap").remove(this.bootstrap);
    }
    return (A) this;
  }
  
  public boolean hasBootstrap() {
    return this.bootstrap != null;
  }
  
  public BootstrapNested<A> withNewBootstrap() {
    return new BootstrapNested(null);
  }
  
  public BootstrapNested<A> withNewBootstrapLike(Bootstrap item) {
    return new BootstrapNested(item);
  }
  
  public BootstrapNested<A> editBootstrap() {
    return withNewBootstrapLike(java.util.Optional.ofNullable(buildBootstrap()).orElse(null));
  }
  
  public BootstrapNested<A> editOrNewBootstrap() {
    return withNewBootstrapLike(java.util.Optional.ofNullable(buildBootstrap()).orElse(new BootstrapBuilder().build()));
  }
  
  public BootstrapNested<A> editOrNewBootstrapLike(Bootstrap item) {
    return withNewBootstrapLike(java.util.Optional.ofNullable(buildBootstrap()).orElse(item));
  }
  
  public String getClusterName() {
    return this.clusterName;
  }
  
  public A withClusterName(String clusterName) {
    this.clusterName = clusterName;
    return (A) this;
  }
  
  public boolean hasClusterName() {
    return this.clusterName != null;
  }
  
  public String getFailureDomain() {
    return this.failureDomain;
  }
  
  public A withFailureDomain(String failureDomain) {
    this.failureDomain = failureDomain;
    return (A) this;
  }
  
  public boolean hasFailureDomain() {
    return this.failureDomain != null;
  }
  
  public ObjectReference buildInfrastructureRef() {
    return this.infrastructureRef != null ? this.infrastructureRef.build() : null;
  }
  
  public A withInfrastructureRef(ObjectReference infrastructureRef) {
    this._visitables.remove("infrastructureRef");
    if (infrastructureRef != null) {
        this.infrastructureRef = new ObjectReferenceBuilder(infrastructureRef);
        this._visitables.get("infrastructureRef").add(this.infrastructureRef);
    } else {
        this.infrastructureRef = null;
        this._visitables.get("infrastructureRef").remove(this.infrastructureRef);
    }
    return (A) this;
  }
  
  public boolean hasInfrastructureRef() {
    return this.infrastructureRef != null;
  }
  
  public InfrastructureRefNested<A> withNewInfrastructureRef() {
    return new InfrastructureRefNested(null);
  }
  
  public InfrastructureRefNested<A> withNewInfrastructureRefLike(ObjectReference item) {
    return new InfrastructureRefNested(item);
  }
  
  public InfrastructureRefNested<A> editInfrastructureRef() {
    return withNewInfrastructureRefLike(java.util.Optional.ofNullable(buildInfrastructureRef()).orElse(null));
  }
  
  public InfrastructureRefNested<A> editOrNewInfrastructureRef() {
    return withNewInfrastructureRefLike(java.util.Optional.ofNullable(buildInfrastructureRef()).orElse(new ObjectReferenceBuilder().build()));
  }
  
  public InfrastructureRefNested<A> editOrNewInfrastructureRefLike(ObjectReference item) {
    return withNewInfrastructureRefLike(java.util.Optional.ofNullable(buildInfrastructureRef()).orElse(item));
  }
  
  public Duration getNodeDeletionTimeout() {
    return this.nodeDeletionTimeout;
  }
  
  public A withNodeDeletionTimeout(Duration nodeDeletionTimeout) {
    this.nodeDeletionTimeout = nodeDeletionTimeout;
    return (A) this;
  }
  
  public boolean hasNodeDeletionTimeout() {
    return this.nodeDeletionTimeout != null;
  }
  
  public Duration getNodeDrainTimeout() {
    return this.nodeDrainTimeout;
  }
  
  public A withNodeDrainTimeout(Duration nodeDrainTimeout) {
    this.nodeDrainTimeout = nodeDrainTimeout;
    return (A) this;
  }
  
  public boolean hasNodeDrainTimeout() {
    return this.nodeDrainTimeout != null;
  }
  
  public Duration getNodeVolumeDetachTimeout() {
    return this.nodeVolumeDetachTimeout;
  }
  
  public A withNodeVolumeDetachTimeout(Duration nodeVolumeDetachTimeout) {
    this.nodeVolumeDetachTimeout = nodeVolumeDetachTimeout;
    return (A) this;
  }
  
  public boolean hasNodeVolumeDetachTimeout() {
    return this.nodeVolumeDetachTimeout != null;
  }
  
  public String getProviderID() {
    return this.providerID;
  }
  
  public A withProviderID(String providerID) {
    this.providerID = providerID;
    return (A) this;
  }
  
  public boolean hasProviderID() {
    return this.providerID != null;
  }
  
  public String getVersion() {
    return this.version;
  }
  
  public A withVersion(String version) {
    this.version = version;
    return (A) this;
  }
  
  public boolean hasVersion() {
    return this.version != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    MachineSpecFluent that = (MachineSpecFluent) o;
    if (!java.util.Objects.equals(bootstrap, that.bootstrap)) return false;
    if (!java.util.Objects.equals(clusterName, that.clusterName)) return false;
    if (!java.util.Objects.equals(failureDomain, that.failureDomain)) return false;
    if (!java.util.Objects.equals(infrastructureRef, that.infrastructureRef)) return false;
    if (!java.util.Objects.equals(nodeDeletionTimeout, that.nodeDeletionTimeout)) return false;
    if (!java.util.Objects.equals(nodeDrainTimeout, that.nodeDrainTimeout)) return false;
    if (!java.util.Objects.equals(nodeVolumeDetachTimeout, that.nodeVolumeDetachTimeout)) return false;
    if (!java.util.Objects.equals(providerID, that.providerID)) return false;
    if (!java.util.Objects.equals(version, that.version)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(bootstrap,  clusterName,  failureDomain,  infrastructureRef,  nodeDeletionTimeout,  nodeDrainTimeout,  nodeVolumeDetachTimeout,  providerID,  version,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (bootstrap != null) { sb.append("bootstrap:"); sb.append(bootstrap + ","); }
    if (clusterName != null) { sb.append("clusterName:"); sb.append(clusterName + ","); }
    if (failureDomain != null) { sb.append("failureDomain:"); sb.append(failureDomain + ","); }
    if (infrastructureRef != null) { sb.append("infrastructureRef:"); sb.append(infrastructureRef + ","); }
    if (nodeDeletionTimeout != null) { sb.append("nodeDeletionTimeout:"); sb.append(nodeDeletionTimeout + ","); }
    if (nodeDrainTimeout != null) { sb.append("nodeDrainTimeout:"); sb.append(nodeDrainTimeout + ","); }
    if (nodeVolumeDetachTimeout != null) { sb.append("nodeVolumeDetachTimeout:"); sb.append(nodeVolumeDetachTimeout + ","); }
    if (providerID != null) { sb.append("providerID:"); sb.append(providerID + ","); }
    if (version != null) { sb.append("version:"); sb.append(version + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class BootstrapNested<N> extends BootstrapFluent<BootstrapNested<N>> implements Nested<N>{
    BootstrapNested(Bootstrap item) {
      this.builder = new BootstrapBuilder(this, item);
    }
    BootstrapBuilder builder;
    
    public N and() {
      return (N) MachineSpecFluent.this.withBootstrap(builder.build());
    }
    
    public N endBootstrap() {
      return and();
    }
    
  
  }
  public class InfrastructureRefNested<N> extends ObjectReferenceFluent<InfrastructureRefNested<N>> implements Nested<N>{
    InfrastructureRefNested(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    ObjectReferenceBuilder builder;
    
    public N and() {
      return (N) MachineSpecFluent.this.withInfrastructureRef(builder.build());
    }
    
    public N endInfrastructureRef() {
      return and();
    }
    
  
  }

}