package io.fabric8.kubernetes.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ImageVolumeSourceFluent<A extends ImageVolumeSourceFluent<A>> extends BaseFluent<A>{
  public ImageVolumeSourceFluent() {
  }
  
  public ImageVolumeSourceFluent(ImageVolumeSource instance) {
    this.copyInstance(instance);
  }
  private String pullPolicy;
  private String reference;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ImageVolumeSource instance) {
    instance = (instance != null ? instance : new ImageVolumeSource());
    if (instance != null) {
          this.withPullPolicy(instance.getPullPolicy());
          this.withReference(instance.getReference());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getPullPolicy() {
    return this.pullPolicy;
  }
  
  public A withPullPolicy(String pullPolicy) {
    this.pullPolicy = pullPolicy;
    return (A) this;
  }
  
  public boolean hasPullPolicy() {
    return this.pullPolicy != null;
  }
  
  public String getReference() {
    return this.reference;
  }
  
  public A withReference(String reference) {
    this.reference = reference;
    return (A) this;
  }
  
  public boolean hasReference() {
    return this.reference != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ImageVolumeSourceFluent that = (ImageVolumeSourceFluent) o;
    if (!java.util.Objects.equals(pullPolicy, that.pullPolicy)) return false;
    if (!java.util.Objects.equals(reference, that.reference)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(pullPolicy,  reference,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (pullPolicy != null) { sb.append("pullPolicy:"); sb.append(pullPolicy + ","); }
    if (reference != null) { sb.append("reference:"); sb.append(reference + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}