package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ClusterBuilder extends ClusterFluent<ClusterBuilder> implements VisitableBuilder<Cluster,ClusterBuilder>{
  public ClusterBuilder() {
    this(new Cluster());
  }
  
  public ClusterBuilder(ClusterFluent<?> fluent) {
    this(fluent, new Cluster());
  }
  
  public ClusterBuilder(ClusterFluent<?> fluent,Cluster instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ClusterBuilder(Cluster instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ClusterFluent<?> fluent;
  
  public Cluster build() {
    Cluster buildable = new Cluster(fluent.getCertificateAuthority(),fluent.getCertificateAuthorityData(),fluent.getDisableCompression(),fluent.buildExtensions(),fluent.getInsecureSkipTlsVerify(),fluent.getProxyUrl(),fluent.getServer(),fluent.getTlsServerName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}