package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class FlockerVolumeSourceBuilder extends FlockerVolumeSourceFluent<FlockerVolumeSourceBuilder> implements VisitableBuilder<FlockerVolumeSource,FlockerVolumeSourceBuilder>{
  public FlockerVolumeSourceBuilder() {
    this(new FlockerVolumeSource());
  }
  
  public FlockerVolumeSourceBuilder(FlockerVolumeSourceFluent<?> fluent) {
    this(fluent, new FlockerVolumeSource());
  }
  
  public FlockerVolumeSourceBuilder(FlockerVolumeSourceFluent<?> fluent,FlockerVolumeSource instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public FlockerVolumeSourceBuilder(FlockerVolumeSource instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  FlockerVolumeSourceFluent<?> fluent;
  
  public FlockerVolumeSource build() {
    FlockerVolumeSource buildable = new FlockerVolumeSource(fluent.getDatasetName(),fluent.getDatasetUUID());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}