package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class GlusterfsVolumeSourceBuilder extends GlusterfsVolumeSourceFluent<GlusterfsVolumeSourceBuilder> implements VisitableBuilder<GlusterfsVolumeSource,GlusterfsVolumeSourceBuilder>{
  public GlusterfsVolumeSourceBuilder() {
    this(new GlusterfsVolumeSource());
  }
  
  public GlusterfsVolumeSourceBuilder(GlusterfsVolumeSourceFluent<?> fluent) {
    this(fluent, new GlusterfsVolumeSource());
  }
  
  public GlusterfsVolumeSourceBuilder(GlusterfsVolumeSourceFluent<?> fluent,GlusterfsVolumeSource instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public GlusterfsVolumeSourceBuilder(GlusterfsVolumeSource instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  GlusterfsVolumeSourceFluent<?> fluent;
  
  public GlusterfsVolumeSource build() {
    GlusterfsVolumeSource buildable = new GlusterfsVolumeSource(fluent.getEndpoints(),fluent.getPath(),fluent.getReadOnly());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}