package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ConfigFluent<A extends ConfigFluent<A>> extends BaseFluent<A>{
  public ConfigFluent() {
  }
  
  public ConfigFluent(Config instance) {
    this.copyInstance(instance);
  }
  private String apiVersion;
  private ArrayList<NamedClusterBuilder> clusters = new ArrayList<NamedClusterBuilder>();
  private ArrayList<NamedContextBuilder> contexts = new ArrayList<NamedContextBuilder>();
  private String currentContext;
  private ArrayList<NamedExtensionBuilder> extensions = new ArrayList<NamedExtensionBuilder>();
  private String kind;
  private PreferencesBuilder preferences;
  private ArrayList<NamedAuthInfoBuilder> users = new ArrayList<NamedAuthInfoBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(Config instance) {
    instance = (instance != null ? instance : new Config());
    if (instance != null) {
          this.withApiVersion(instance.getApiVersion());
          this.withClusters(instance.getClusters());
          this.withContexts(instance.getContexts());
          this.withCurrentContext(instance.getCurrentContext());
          this.withExtensions(instance.getExtensions());
          this.withKind(instance.getKind());
          this.withPreferences(instance.getPreferences());
          this.withUsers(instance.getUsers());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getApiVersion() {
    return this.apiVersion;
  }
  
  public A withApiVersion(String apiVersion) {
    this.apiVersion = apiVersion;
    return (A) this;
  }
  
  public boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  
  public A addToClusters(int index,NamedCluster item) {
    if (this.clusters == null) {this.clusters = new ArrayList<NamedClusterBuilder>();}
    NamedClusterBuilder builder = new NamedClusterBuilder(item);
    if (index < 0 || index >= clusters.size()) {
        _visitables.get("clusters").add(builder);
        clusters.add(builder);
    } else {
        _visitables.get("clusters").add(builder);
        clusters.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToClusters(int index,NamedCluster item) {
    if (this.clusters == null) {this.clusters = new ArrayList<NamedClusterBuilder>();}
    NamedClusterBuilder builder = new NamedClusterBuilder(item);
    if (index < 0 || index >= clusters.size()) {
        _visitables.get("clusters").add(builder);
        clusters.add(builder);
    } else {
        _visitables.get("clusters").add(builder);
        clusters.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToClusters(io.fabric8.kubernetes.api.model.NamedCluster... items) {
    if (this.clusters == null) {this.clusters = new ArrayList<NamedClusterBuilder>();}
    for (NamedCluster item : items) {NamedClusterBuilder builder = new NamedClusterBuilder(item);_visitables.get("clusters").add(builder);this.clusters.add(builder);} return (A)this;
  }
  
  public A addAllToClusters(Collection<NamedCluster> items) {
    if (this.clusters == null) {this.clusters = new ArrayList<NamedClusterBuilder>();}
    for (NamedCluster item : items) {NamedClusterBuilder builder = new NamedClusterBuilder(item);_visitables.get("clusters").add(builder);this.clusters.add(builder);} return (A)this;
  }
  
  public A removeFromClusters(io.fabric8.kubernetes.api.model.NamedCluster... items) {
    if (this.clusters == null) return (A)this;
    for (NamedCluster item : items) {NamedClusterBuilder builder = new NamedClusterBuilder(item);_visitables.get("clusters").remove(builder); this.clusters.remove(builder);} return (A)this;
  }
  
  public A removeAllFromClusters(Collection<NamedCluster> items) {
    if (this.clusters == null) return (A)this;
    for (NamedCluster item : items) {NamedClusterBuilder builder = new NamedClusterBuilder(item);_visitables.get("clusters").remove(builder); this.clusters.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromClusters(Predicate<NamedClusterBuilder> predicate) {
    if (clusters == null) return (A) this;
    final Iterator<NamedClusterBuilder> each = clusters.iterator();
    final List visitables = _visitables.get("clusters");
    while (each.hasNext()) {
      NamedClusterBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<NamedCluster> buildClusters() {
    return this.clusters != null ? build(clusters) : null;
  }
  
  public NamedCluster buildCluster(int index) {
    return this.clusters.get(index).build();
  }
  
  public NamedCluster buildFirstCluster() {
    return this.clusters.get(0).build();
  }
  
  public NamedCluster buildLastCluster() {
    return this.clusters.get(clusters.size() - 1).build();
  }
  
  public NamedCluster buildMatchingCluster(Predicate<NamedClusterBuilder> predicate) {
      for (NamedClusterBuilder item : clusters) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingCluster(Predicate<NamedClusterBuilder> predicate) {
      for (NamedClusterBuilder item : clusters) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withClusters(List<NamedCluster> clusters) {
    if (this.clusters != null) {
      this._visitables.get("clusters").clear();
    }
    if (clusters != null) {
        this.clusters = new ArrayList();
        for (NamedCluster item : clusters) {
          this.addToClusters(item);
        }
    } else {
      this.clusters = null;
    }
    return (A) this;
  }
  
  public A withClusters(io.fabric8.kubernetes.api.model.NamedCluster... clusters) {
    if (this.clusters != null) {
        this.clusters.clear();
        _visitables.remove("clusters");
    }
    if (clusters != null) {
      for (NamedCluster item : clusters) {
        this.addToClusters(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasClusters() {
    return this.clusters != null && !this.clusters.isEmpty();
  }
  
  public ClustersNested<A> addNewCluster() {
    return new ClustersNested(-1, null);
  }
  
  public ClustersNested<A> addNewClusterLike(NamedCluster item) {
    return new ClustersNested(-1, item);
  }
  
  public ClustersNested<A> setNewClusterLike(int index,NamedCluster item) {
    return new ClustersNested(index, item);
  }
  
  public ClustersNested<A> editCluster(int index) {
    if (clusters.size() <= index) throw new RuntimeException("Can't edit clusters. Index exceeds size.");
    return setNewClusterLike(index, buildCluster(index));
  }
  
  public ClustersNested<A> editFirstCluster() {
    if (clusters.size() == 0) throw new RuntimeException("Can't edit first clusters. The list is empty.");
    return setNewClusterLike(0, buildCluster(0));
  }
  
  public ClustersNested<A> editLastCluster() {
    int index = clusters.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last clusters. The list is empty.");
    return setNewClusterLike(index, buildCluster(index));
  }
  
  public ClustersNested<A> editMatchingCluster(Predicate<NamedClusterBuilder> predicate) {
    int index = -1;
    for (int i=0;i<clusters.size();i++) { 
    if (predicate.test(clusters.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching clusters. No match found.");
    return setNewClusterLike(index, buildCluster(index));
  }
  
  public A addToContexts(int index,NamedContext item) {
    if (this.contexts == null) {this.contexts = new ArrayList<NamedContextBuilder>();}
    NamedContextBuilder builder = new NamedContextBuilder(item);
    if (index < 0 || index >= contexts.size()) {
        _visitables.get("contexts").add(builder);
        contexts.add(builder);
    } else {
        _visitables.get("contexts").add(builder);
        contexts.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToContexts(int index,NamedContext item) {
    if (this.contexts == null) {this.contexts = new ArrayList<NamedContextBuilder>();}
    NamedContextBuilder builder = new NamedContextBuilder(item);
    if (index < 0 || index >= contexts.size()) {
        _visitables.get("contexts").add(builder);
        contexts.add(builder);
    } else {
        _visitables.get("contexts").add(builder);
        contexts.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToContexts(io.fabric8.kubernetes.api.model.NamedContext... items) {
    if (this.contexts == null) {this.contexts = new ArrayList<NamedContextBuilder>();}
    for (NamedContext item : items) {NamedContextBuilder builder = new NamedContextBuilder(item);_visitables.get("contexts").add(builder);this.contexts.add(builder);} return (A)this;
  }
  
  public A addAllToContexts(Collection<NamedContext> items) {
    if (this.contexts == null) {this.contexts = new ArrayList<NamedContextBuilder>();}
    for (NamedContext item : items) {NamedContextBuilder builder = new NamedContextBuilder(item);_visitables.get("contexts").add(builder);this.contexts.add(builder);} return (A)this;
  }
  
  public A removeFromContexts(io.fabric8.kubernetes.api.model.NamedContext... items) {
    if (this.contexts == null) return (A)this;
    for (NamedContext item : items) {NamedContextBuilder builder = new NamedContextBuilder(item);_visitables.get("contexts").remove(builder); this.contexts.remove(builder);} return (A)this;
  }
  
  public A removeAllFromContexts(Collection<NamedContext> items) {
    if (this.contexts == null) return (A)this;
    for (NamedContext item : items) {NamedContextBuilder builder = new NamedContextBuilder(item);_visitables.get("contexts").remove(builder); this.contexts.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromContexts(Predicate<NamedContextBuilder> predicate) {
    if (contexts == null) return (A) this;
    final Iterator<NamedContextBuilder> each = contexts.iterator();
    final List visitables = _visitables.get("contexts");
    while (each.hasNext()) {
      NamedContextBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<NamedContext> buildContexts() {
    return this.contexts != null ? build(contexts) : null;
  }
  
  public NamedContext buildContext(int index) {
    return this.contexts.get(index).build();
  }
  
  public NamedContext buildFirstContext() {
    return this.contexts.get(0).build();
  }
  
  public NamedContext buildLastContext() {
    return this.contexts.get(contexts.size() - 1).build();
  }
  
  public NamedContext buildMatchingContext(Predicate<NamedContextBuilder> predicate) {
      for (NamedContextBuilder item : contexts) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingContext(Predicate<NamedContextBuilder> predicate) {
      for (NamedContextBuilder item : contexts) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withContexts(List<NamedContext> contexts) {
    if (this.contexts != null) {
      this._visitables.get("contexts").clear();
    }
    if (contexts != null) {
        this.contexts = new ArrayList();
        for (NamedContext item : contexts) {
          this.addToContexts(item);
        }
    } else {
      this.contexts = null;
    }
    return (A) this;
  }
  
  public A withContexts(io.fabric8.kubernetes.api.model.NamedContext... contexts) {
    if (this.contexts != null) {
        this.contexts.clear();
        _visitables.remove("contexts");
    }
    if (contexts != null) {
      for (NamedContext item : contexts) {
        this.addToContexts(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasContexts() {
    return this.contexts != null && !this.contexts.isEmpty();
  }
  
  public ContextsNested<A> addNewContext() {
    return new ContextsNested(-1, null);
  }
  
  public ContextsNested<A> addNewContextLike(NamedContext item) {
    return new ContextsNested(-1, item);
  }
  
  public ContextsNested<A> setNewContextLike(int index,NamedContext item) {
    return new ContextsNested(index, item);
  }
  
  public ContextsNested<A> editContext(int index) {
    if (contexts.size() <= index) throw new RuntimeException("Can't edit contexts. Index exceeds size.");
    return setNewContextLike(index, buildContext(index));
  }
  
  public ContextsNested<A> editFirstContext() {
    if (contexts.size() == 0) throw new RuntimeException("Can't edit first contexts. The list is empty.");
    return setNewContextLike(0, buildContext(0));
  }
  
  public ContextsNested<A> editLastContext() {
    int index = contexts.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last contexts. The list is empty.");
    return setNewContextLike(index, buildContext(index));
  }
  
  public ContextsNested<A> editMatchingContext(Predicate<NamedContextBuilder> predicate) {
    int index = -1;
    for (int i=0;i<contexts.size();i++) { 
    if (predicate.test(contexts.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching contexts. No match found.");
    return setNewContextLike(index, buildContext(index));
  }
  
  public String getCurrentContext() {
    return this.currentContext;
  }
  
  public A withCurrentContext(String currentContext) {
    this.currentContext = currentContext;
    return (A) this;
  }
  
  public boolean hasCurrentContext() {
    return this.currentContext != null;
  }
  
  public A addToExtensions(int index,NamedExtension item) {
    if (this.extensions == null) {this.extensions = new ArrayList<NamedExtensionBuilder>();}
    NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
    if (index < 0 || index >= extensions.size()) {
        _visitables.get("extensions").add(builder);
        extensions.add(builder);
    } else {
        _visitables.get("extensions").add(builder);
        extensions.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToExtensions(int index,NamedExtension item) {
    if (this.extensions == null) {this.extensions = new ArrayList<NamedExtensionBuilder>();}
    NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
    if (index < 0 || index >= extensions.size()) {
        _visitables.get("extensions").add(builder);
        extensions.add(builder);
    } else {
        _visitables.get("extensions").add(builder);
        extensions.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToExtensions(io.fabric8.kubernetes.api.model.NamedExtension... items) {
    if (this.extensions == null) {this.extensions = new ArrayList<NamedExtensionBuilder>();}
    for (NamedExtension item : items) {NamedExtensionBuilder builder = new NamedExtensionBuilder(item);_visitables.get("extensions").add(builder);this.extensions.add(builder);} return (A)this;
  }
  
  public A addAllToExtensions(Collection<NamedExtension> items) {
    if (this.extensions == null) {this.extensions = new ArrayList<NamedExtensionBuilder>();}
    for (NamedExtension item : items) {NamedExtensionBuilder builder = new NamedExtensionBuilder(item);_visitables.get("extensions").add(builder);this.extensions.add(builder);} return (A)this;
  }
  
  public A removeFromExtensions(io.fabric8.kubernetes.api.model.NamedExtension... items) {
    if (this.extensions == null) return (A)this;
    for (NamedExtension item : items) {NamedExtensionBuilder builder = new NamedExtensionBuilder(item);_visitables.get("extensions").remove(builder); this.extensions.remove(builder);} return (A)this;
  }
  
  public A removeAllFromExtensions(Collection<NamedExtension> items) {
    if (this.extensions == null) return (A)this;
    for (NamedExtension item : items) {NamedExtensionBuilder builder = new NamedExtensionBuilder(item);_visitables.get("extensions").remove(builder); this.extensions.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromExtensions(Predicate<NamedExtensionBuilder> predicate) {
    if (extensions == null) return (A) this;
    final Iterator<NamedExtensionBuilder> each = extensions.iterator();
    final List visitables = _visitables.get("extensions");
    while (each.hasNext()) {
      NamedExtensionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<NamedExtension> buildExtensions() {
    return this.extensions != null ? build(extensions) : null;
  }
  
  public NamedExtension buildExtension(int index) {
    return this.extensions.get(index).build();
  }
  
  public NamedExtension buildFirstExtension() {
    return this.extensions.get(0).build();
  }
  
  public NamedExtension buildLastExtension() {
    return this.extensions.get(extensions.size() - 1).build();
  }
  
  public NamedExtension buildMatchingExtension(Predicate<NamedExtensionBuilder> predicate) {
      for (NamedExtensionBuilder item : extensions) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingExtension(Predicate<NamedExtensionBuilder> predicate) {
      for (NamedExtensionBuilder item : extensions) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withExtensions(List<NamedExtension> extensions) {
    if (this.extensions != null) {
      this._visitables.get("extensions").clear();
    }
    if (extensions != null) {
        this.extensions = new ArrayList();
        for (NamedExtension item : extensions) {
          this.addToExtensions(item);
        }
    } else {
      this.extensions = null;
    }
    return (A) this;
  }
  
  public A withExtensions(io.fabric8.kubernetes.api.model.NamedExtension... extensions) {
    if (this.extensions != null) {
        this.extensions.clear();
        _visitables.remove("extensions");
    }
    if (extensions != null) {
      for (NamedExtension item : extensions) {
        this.addToExtensions(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasExtensions() {
    return this.extensions != null && !this.extensions.isEmpty();
  }
  
  public A addNewExtension(Object extension,String name) {
    return (A)addToExtensions(new NamedExtension(extension, name));
  }
  
  public ExtensionsNested<A> addNewExtension() {
    return new ExtensionsNested(-1, null);
  }
  
  public ExtensionsNested<A> addNewExtensionLike(NamedExtension item) {
    return new ExtensionsNested(-1, item);
  }
  
  public ExtensionsNested<A> setNewExtensionLike(int index,NamedExtension item) {
    return new ExtensionsNested(index, item);
  }
  
  public ExtensionsNested<A> editExtension(int index) {
    if (extensions.size() <= index) throw new RuntimeException("Can't edit extensions. Index exceeds size.");
    return setNewExtensionLike(index, buildExtension(index));
  }
  
  public ExtensionsNested<A> editFirstExtension() {
    if (extensions.size() == 0) throw new RuntimeException("Can't edit first extensions. The list is empty.");
    return setNewExtensionLike(0, buildExtension(0));
  }
  
  public ExtensionsNested<A> editLastExtension() {
    int index = extensions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last extensions. The list is empty.");
    return setNewExtensionLike(index, buildExtension(index));
  }
  
  public ExtensionsNested<A> editMatchingExtension(Predicate<NamedExtensionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<extensions.size();i++) { 
    if (predicate.test(extensions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching extensions. No match found.");
    return setNewExtensionLike(index, buildExtension(index));
  }
  
  public String getKind() {
    return this.kind;
  }
  
  public A withKind(String kind) {
    this.kind = kind;
    return (A) this;
  }
  
  public boolean hasKind() {
    return this.kind != null;
  }
  
  public Preferences buildPreferences() {
    return this.preferences != null ? this.preferences.build() : null;
  }
  
  public A withPreferences(Preferences preferences) {
    this._visitables.remove("preferences");
    if (preferences != null) {
        this.preferences = new PreferencesBuilder(preferences);
        this._visitables.get("preferences").add(this.preferences);
    } else {
        this.preferences = null;
        this._visitables.get("preferences").remove(this.preferences);
    }
    return (A) this;
  }
  
  public boolean hasPreferences() {
    return this.preferences != null;
  }
  
  public PreferencesNested<A> withNewPreferences() {
    return new PreferencesNested(null);
  }
  
  public PreferencesNested<A> withNewPreferencesLike(Preferences item) {
    return new PreferencesNested(item);
  }
  
  public PreferencesNested<A> editPreferences() {
    return withNewPreferencesLike(java.util.Optional.ofNullable(buildPreferences()).orElse(null));
  }
  
  public PreferencesNested<A> editOrNewPreferences() {
    return withNewPreferencesLike(java.util.Optional.ofNullable(buildPreferences()).orElse(new PreferencesBuilder().build()));
  }
  
  public PreferencesNested<A> editOrNewPreferencesLike(Preferences item) {
    return withNewPreferencesLike(java.util.Optional.ofNullable(buildPreferences()).orElse(item));
  }
  
  public A addToUsers(int index,NamedAuthInfo item) {
    if (this.users == null) {this.users = new ArrayList<NamedAuthInfoBuilder>();}
    NamedAuthInfoBuilder builder = new NamedAuthInfoBuilder(item);
    if (index < 0 || index >= users.size()) {
        _visitables.get("users").add(builder);
        users.add(builder);
    } else {
        _visitables.get("users").add(builder);
        users.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToUsers(int index,NamedAuthInfo item) {
    if (this.users == null) {this.users = new ArrayList<NamedAuthInfoBuilder>();}
    NamedAuthInfoBuilder builder = new NamedAuthInfoBuilder(item);
    if (index < 0 || index >= users.size()) {
        _visitables.get("users").add(builder);
        users.add(builder);
    } else {
        _visitables.get("users").add(builder);
        users.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToUsers(io.fabric8.kubernetes.api.model.NamedAuthInfo... items) {
    if (this.users == null) {this.users = new ArrayList<NamedAuthInfoBuilder>();}
    for (NamedAuthInfo item : items) {NamedAuthInfoBuilder builder = new NamedAuthInfoBuilder(item);_visitables.get("users").add(builder);this.users.add(builder);} return (A)this;
  }
  
  public A addAllToUsers(Collection<NamedAuthInfo> items) {
    if (this.users == null) {this.users = new ArrayList<NamedAuthInfoBuilder>();}
    for (NamedAuthInfo item : items) {NamedAuthInfoBuilder builder = new NamedAuthInfoBuilder(item);_visitables.get("users").add(builder);this.users.add(builder);} return (A)this;
  }
  
  public A removeFromUsers(io.fabric8.kubernetes.api.model.NamedAuthInfo... items) {
    if (this.users == null) return (A)this;
    for (NamedAuthInfo item : items) {NamedAuthInfoBuilder builder = new NamedAuthInfoBuilder(item);_visitables.get("users").remove(builder); this.users.remove(builder);} return (A)this;
  }
  
  public A removeAllFromUsers(Collection<NamedAuthInfo> items) {
    if (this.users == null) return (A)this;
    for (NamedAuthInfo item : items) {NamedAuthInfoBuilder builder = new NamedAuthInfoBuilder(item);_visitables.get("users").remove(builder); this.users.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromUsers(Predicate<NamedAuthInfoBuilder> predicate) {
    if (users == null) return (A) this;
    final Iterator<NamedAuthInfoBuilder> each = users.iterator();
    final List visitables = _visitables.get("users");
    while (each.hasNext()) {
      NamedAuthInfoBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<NamedAuthInfo> buildUsers() {
    return this.users != null ? build(users) : null;
  }
  
  public NamedAuthInfo buildUser(int index) {
    return this.users.get(index).build();
  }
  
  public NamedAuthInfo buildFirstUser() {
    return this.users.get(0).build();
  }
  
  public NamedAuthInfo buildLastUser() {
    return this.users.get(users.size() - 1).build();
  }
  
  public NamedAuthInfo buildMatchingUser(Predicate<NamedAuthInfoBuilder> predicate) {
      for (NamedAuthInfoBuilder item : users) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingUser(Predicate<NamedAuthInfoBuilder> predicate) {
      for (NamedAuthInfoBuilder item : users) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withUsers(List<NamedAuthInfo> users) {
    if (this.users != null) {
      this._visitables.get("users").clear();
    }
    if (users != null) {
        this.users = new ArrayList();
        for (NamedAuthInfo item : users) {
          this.addToUsers(item);
        }
    } else {
      this.users = null;
    }
    return (A) this;
  }
  
  public A withUsers(io.fabric8.kubernetes.api.model.NamedAuthInfo... users) {
    if (this.users != null) {
        this.users.clear();
        _visitables.remove("users");
    }
    if (users != null) {
      for (NamedAuthInfo item : users) {
        this.addToUsers(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasUsers() {
    return this.users != null && !this.users.isEmpty();
  }
  
  public UsersNested<A> addNewUser() {
    return new UsersNested(-1, null);
  }
  
  public UsersNested<A> addNewUserLike(NamedAuthInfo item) {
    return new UsersNested(-1, item);
  }
  
  public UsersNested<A> setNewUserLike(int index,NamedAuthInfo item) {
    return new UsersNested(index, item);
  }
  
  public UsersNested<A> editUser(int index) {
    if (users.size() <= index) throw new RuntimeException("Can't edit users. Index exceeds size.");
    return setNewUserLike(index, buildUser(index));
  }
  
  public UsersNested<A> editFirstUser() {
    if (users.size() == 0) throw new RuntimeException("Can't edit first users. The list is empty.");
    return setNewUserLike(0, buildUser(0));
  }
  
  public UsersNested<A> editLastUser() {
    int index = users.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last users. The list is empty.");
    return setNewUserLike(index, buildUser(index));
  }
  
  public UsersNested<A> editMatchingUser(Predicate<NamedAuthInfoBuilder> predicate) {
    int index = -1;
    for (int i=0;i<users.size();i++) { 
    if (predicate.test(users.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching users. No match found.");
    return setNewUserLike(index, buildUser(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ConfigFluent that = (ConfigFluent) o;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;
    if (!java.util.Objects.equals(clusters, that.clusters)) return false;
    if (!java.util.Objects.equals(contexts, that.contexts)) return false;
    if (!java.util.Objects.equals(currentContext, that.currentContext)) return false;
    if (!java.util.Objects.equals(extensions, that.extensions)) return false;
    if (!java.util.Objects.equals(kind, that.kind)) return false;
    if (!java.util.Objects.equals(preferences, that.preferences)) return false;
    if (!java.util.Objects.equals(users, that.users)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  clusters,  contexts,  currentContext,  extensions,  kind,  preferences,  users,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (clusters != null && !clusters.isEmpty()) { sb.append("clusters:"); sb.append(clusters + ","); }
    if (contexts != null && !contexts.isEmpty()) { sb.append("contexts:"); sb.append(contexts + ","); }
    if (currentContext != null) { sb.append("currentContext:"); sb.append(currentContext + ","); }
    if (extensions != null && !extensions.isEmpty()) { sb.append("extensions:"); sb.append(extensions + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (preferences != null) { sb.append("preferences:"); sb.append(preferences + ","); }
    if (users != null && !users.isEmpty()) { sb.append("users:"); sb.append(users + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ClustersNested<N> extends NamedClusterFluent<ClustersNested<N>> implements Nested<N>{
    ClustersNested(int index,NamedCluster item) {
      this.index = index;
      this.builder = new NamedClusterBuilder(this, item);
    }
    NamedClusterBuilder builder;
    int index;
    
    public N and() {
      return (N) ConfigFluent.this.setToClusters(index,builder.build());
    }
    
    public N endCluster() {
      return and();
    }
    
  
  }
  public class ContextsNested<N> extends NamedContextFluent<ContextsNested<N>> implements Nested<N>{
    ContextsNested(int index,NamedContext item) {
      this.index = index;
      this.builder = new NamedContextBuilder(this, item);
    }
    NamedContextBuilder builder;
    int index;
    
    public N and() {
      return (N) ConfigFluent.this.setToContexts(index,builder.build());
    }
    
    public N endContext() {
      return and();
    }
    
  
  }
  public class ExtensionsNested<N> extends NamedExtensionFluent<ExtensionsNested<N>> implements Nested<N>{
    ExtensionsNested(int index,NamedExtension item) {
      this.index = index;
      this.builder = new NamedExtensionBuilder(this, item);
    }
    NamedExtensionBuilder builder;
    int index;
    
    public N and() {
      return (N) ConfigFluent.this.setToExtensions(index,builder.build());
    }
    
    public N endExtension() {
      return and();
    }
    
  
  }
  public class PreferencesNested<N> extends PreferencesFluent<PreferencesNested<N>> implements Nested<N>{
    PreferencesNested(Preferences item) {
      this.builder = new PreferencesBuilder(this, item);
    }
    PreferencesBuilder builder;
    
    public N and() {
      return (N) ConfigFluent.this.withPreferences(builder.build());
    }
    
    public N endPreferences() {
      return and();
    }
    
  
  }
  public class UsersNested<N> extends NamedAuthInfoFluent<UsersNested<N>> implements Nested<N>{
    UsersNested(int index,NamedAuthInfo item) {
      this.index = index;
      this.builder = new NamedAuthInfoBuilder(this, item);
    }
    NamedAuthInfoBuilder builder;
    int index;
    
    public N and() {
      return (N) ConfigFluent.this.setToUsers(index,builder.build());
    }
    
    public N endUser() {
      return and();
    }
    
  
  }

}