package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class GroupKindBuilder extends GroupKindFluent<GroupKindBuilder> implements VisitableBuilder<GroupKind,GroupKindBuilder>{
  public GroupKindBuilder() {
    this(new GroupKind());
  }
  
  public GroupKindBuilder(GroupKindFluent<?> fluent) {
    this(fluent, new GroupKind());
  }
  
  public GroupKindBuilder(GroupKindFluent<?> fluent,GroupKind instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public GroupKindBuilder(GroupKind instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  GroupKindFluent<?> fluent;
  
  public GroupKind build() {
    GroupKind buildable = new GroupKind(fluent.getGroup(),fluent.getKind());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}