/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.discovery;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.discovery.Endpoint;
import io.fabric8.kubernetes.api.model.discovery.EndpointConditions;
import io.fabric8.kubernetes.api.model.discovery.EndpointConditionsBuilder;
import io.fabric8.kubernetes.api.model.discovery.EndpointConditionsFluentImpl;
import io.fabric8.kubernetes.api.model.discovery.EndpointFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class EndpointFluentImpl<A extends EndpointFluent<A>>
extends BaseFluent<A>
implements EndpointFluent<A> {
    private List<String> addresses = new ArrayList<String>();
    private EndpointConditionsBuilder conditions;
    private String hostname;
    private ObjectReferenceBuilder targetRef;
    private Map<String, String> topology;

    public EndpointFluentImpl() {
    }

    public EndpointFluentImpl(Endpoint instance) {
        this.withAddresses(instance.getAddresses());
        this.withConditions(instance.getConditions());
        this.withHostname(instance.getHostname());
        this.withTargetRef(instance.getTargetRef());
        this.withTopology(instance.getTopology());
    }

    @Override
    public A addToAddresses(int index, String item) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<String>();
        }
        this.addresses.add(index, item);
        return (A)this;
    }

    @Override
    public A setToAddresses(int index, String item) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<String>();
        }
        this.addresses.set(index, item);
        return (A)this;
    }

    @Override
    public A addToAddresses(String ... items) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<String>();
        }
        for (String item : items) {
            this.addresses.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToAddresses(Collection<String> items) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<String>();
        }
        for (String item : items) {
            this.addresses.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromAddresses(String ... items) {
        for (String item : items) {
            if (this.addresses == null) continue;
            this.addresses.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAddresses(Collection<String> items) {
        for (String item : items) {
            if (this.addresses == null) continue;
            this.addresses.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getAddresses() {
        return this.addresses;
    }

    @Override
    public String getAddress(int index) {
        return this.addresses.get(index);
    }

    @Override
    public String getFirstAddress() {
        return this.addresses.get(0);
    }

    @Override
    public String getLastAddress() {
        return this.addresses.get(this.addresses.size() - 1);
    }

    @Override
    public String getMatchingAddress(Predicate<String> predicate) {
        for (String item : this.addresses) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingAddress(Predicate<String> predicate) {
        for (String item : this.addresses) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withAddresses(List<String> addresses) {
        if (this.addresses != null) {
            this._visitables.get((Object)"addresses").removeAll(this.addresses);
        }
        if (addresses != null) {
            this.addresses = new ArrayList<String>();
            for (String item : addresses) {
                this.addToAddresses(item);
            }
        } else {
            this.addresses = null;
        }
        return (A)this;
    }

    @Override
    public A withAddresses(String ... addresses) {
        if (this.addresses != null) {
            this.addresses.clear();
        }
        if (addresses != null) {
            for (String item : addresses) {
                this.addToAddresses(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAddresses() {
        return this.addresses != null && !this.addresses.isEmpty();
    }

    @Override
    public A addNewAddress(String arg1) {
        return this.addToAddresses(new String(arg1));
    }

    @Override
    public A addNewAddress(StringBuilder arg1) {
        return this.addToAddresses(new String(arg1));
    }

    @Override
    public A addNewAddress(StringBuffer arg1) {
        return this.addToAddresses(new String(arg1));
    }

    @Override
    @Deprecated
    public EndpointConditions getConditions() {
        return this.conditions != null ? this.conditions.build() : null;
    }

    @Override
    public EndpointConditions buildConditions() {
        return this.conditions != null ? this.conditions.build() : null;
    }

    @Override
    public A withConditions(EndpointConditions conditions) {
        this._visitables.get((Object)"conditions").remove(this.conditions);
        if (conditions != null) {
            this.conditions = new EndpointConditionsBuilder(conditions);
            this._visitables.get((Object)"conditions").add(this.conditions);
        }
        return (A)this;
    }

    @Override
    public Boolean hasConditions() {
        return this.conditions != null;
    }

    @Override
    public A withNewConditions(Boolean ready) {
        return this.withConditions(new EndpointConditions(ready));
    }

    @Override
    public EndpointFluent.ConditionsNested<A> withNewConditions() {
        return new ConditionsNestedImpl();
    }

    @Override
    public EndpointFluent.ConditionsNested<A> withNewConditionsLike(EndpointConditions item) {
        return new ConditionsNestedImpl(item);
    }

    @Override
    public EndpointFluent.ConditionsNested<A> editConditions() {
        return this.withNewConditionsLike(this.getConditions());
    }

    @Override
    public EndpointFluent.ConditionsNested<A> editOrNewConditions() {
        return this.withNewConditionsLike(this.getConditions() != null ? this.getConditions() : new EndpointConditionsBuilder().build());
    }

    @Override
    public EndpointFluent.ConditionsNested<A> editOrNewConditionsLike(EndpointConditions item) {
        return this.withNewConditionsLike(this.getConditions() != null ? this.getConditions() : item);
    }

    @Override
    public String getHostname() {
        return this.hostname;
    }

    @Override
    public A withHostname(String hostname) {
        this.hostname = hostname;
        return (A)this;
    }

    @Override
    public Boolean hasHostname() {
        return this.hostname != null;
    }

    @Override
    public A withNewHostname(String arg1) {
        return this.withHostname(new String(arg1));
    }

    @Override
    public A withNewHostname(StringBuilder arg1) {
        return this.withHostname(new String(arg1));
    }

    @Override
    public A withNewHostname(StringBuffer arg1) {
        return this.withHostname(new String(arg1));
    }

    @Override
    @Deprecated
    public ObjectReference getTargetRef() {
        return this.targetRef != null ? this.targetRef.build() : null;
    }

    @Override
    public ObjectReference buildTargetRef() {
        return this.targetRef != null ? this.targetRef.build() : null;
    }

    @Override
    public A withTargetRef(ObjectReference targetRef) {
        this._visitables.get((Object)"targetRef").remove(this.targetRef);
        if (targetRef != null) {
            this.targetRef = new ObjectReferenceBuilder(targetRef);
            this._visitables.get((Object)"targetRef").add(this.targetRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTargetRef() {
        return this.targetRef != null;
    }

    @Override
    public EndpointFluent.TargetRefNested<A> withNewTargetRef() {
        return new TargetRefNestedImpl();
    }

    @Override
    public EndpointFluent.TargetRefNested<A> withNewTargetRefLike(ObjectReference item) {
        return new TargetRefNestedImpl(item);
    }

    @Override
    public EndpointFluent.TargetRefNested<A> editTargetRef() {
        return this.withNewTargetRefLike(this.getTargetRef());
    }

    @Override
    public EndpointFluent.TargetRefNested<A> editOrNewTargetRef() {
        return this.withNewTargetRefLike(this.getTargetRef() != null ? this.getTargetRef() : new ObjectReferenceBuilder().build());
    }

    @Override
    public EndpointFluent.TargetRefNested<A> editOrNewTargetRefLike(ObjectReference item) {
        return this.withNewTargetRefLike(this.getTargetRef() != null ? this.getTargetRef() : item);
    }

    @Override
    public A addToTopology(String key, String value) {
        if (this.topology == null && key != null && value != null) {
            this.topology = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.topology.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToTopology(Map<String, String> map) {
        if (this.topology == null && map != null) {
            this.topology = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.topology.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromTopology(String key) {
        if (this.topology == null) {
            return (A)this;
        }
        if (key != null && this.topology != null) {
            this.topology.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromTopology(Map<String, String> map) {
        if (this.topology == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.topology == null) continue;
                this.topology.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getTopology() {
        return this.topology;
    }

    @Override
    public A withTopology(Map<String, String> topology) {
        this.topology = topology == null ? null : new LinkedHashMap<String, String>(topology);
        return (A)this;
    }

    @Override
    public Boolean hasTopology() {
        return this.topology != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EndpointFluentImpl that = (EndpointFluentImpl)o;
        if (this.addresses != null ? !this.addresses.equals(that.addresses) : that.addresses != null) {
            return false;
        }
        if (this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null) {
            return false;
        }
        if (this.hostname != null ? !this.hostname.equals(that.hostname) : that.hostname != null) {
            return false;
        }
        if (this.targetRef != null ? !this.targetRef.equals((Object)that.targetRef) : that.targetRef != null) {
            return false;
        }
        return !(this.topology != null ? !this.topology.equals(that.topology) : that.topology != null);
    }

    public class TargetRefNestedImpl<N>
    extends ObjectReferenceFluentImpl<EndpointFluent.TargetRefNested<N>>
    implements EndpointFluent.TargetRefNested<N>,
    Nested<N> {
        private final ObjectReferenceBuilder builder;

        TargetRefNestedImpl(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder((ObjectReferenceFluent)this, item);
        }

        TargetRefNestedImpl() {
            this.builder = new ObjectReferenceBuilder((ObjectReferenceFluent)this);
        }

        @Override
        public N and() {
            return (N)EndpointFluentImpl.this.withTargetRef(this.builder.build());
        }

        @Override
        public N endTargetRef() {
            return this.and();
        }
    }

    public class ConditionsNestedImpl<N>
    extends EndpointConditionsFluentImpl<EndpointFluent.ConditionsNested<N>>
    implements EndpointFluent.ConditionsNested<N>,
    Nested<N> {
        private final EndpointConditionsBuilder builder;

        ConditionsNestedImpl(EndpointConditions item) {
            this.builder = new EndpointConditionsBuilder(this, item);
        }

        ConditionsNestedImpl() {
            this.builder = new EndpointConditionsBuilder(this);
        }

        @Override
        public N and() {
            return (N)EndpointFluentImpl.this.withConditions(this.builder.build());
        }

        @Override
        public N endConditions() {
            return this.and();
        }
    }
}

