package io.fabric8.kubernetes.api.model.discovery.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class EndpointHintsFluent<A extends EndpointHintsFluent<A>> extends BaseFluent<A>{
  public EndpointHintsFluent() {
  }
  
  public EndpointHintsFluent(EndpointHints instance) {
    this.copyInstance(instance);
  }
  private ArrayList<ForNodeBuilder> forNodes = new ArrayList<ForNodeBuilder>();
  private ArrayList<ForZoneBuilder> forZones = new ArrayList<ForZoneBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(EndpointHints instance) {
    instance = (instance != null ? instance : new EndpointHints());
    if (instance != null) {
          this.withForNodes(instance.getForNodes());
          this.withForZones(instance.getForZones());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToForNodes(int index,ForNode item) {
    if (this.forNodes == null) {this.forNodes = new ArrayList<ForNodeBuilder>();}
    ForNodeBuilder builder = new ForNodeBuilder(item);
    if (index < 0 || index >= forNodes.size()) {
        _visitables.get("forNodes").add(builder);
        forNodes.add(builder);
    } else {
        _visitables.get("forNodes").add(builder);
        forNodes.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToForNodes(int index,ForNode item) {
    if (this.forNodes == null) {this.forNodes = new ArrayList<ForNodeBuilder>();}
    ForNodeBuilder builder = new ForNodeBuilder(item);
    if (index < 0 || index >= forNodes.size()) {
        _visitables.get("forNodes").add(builder);
        forNodes.add(builder);
    } else {
        _visitables.get("forNodes").add(builder);
        forNodes.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToForNodes(io.fabric8.kubernetes.api.model.discovery.v1.ForNode... items) {
    if (this.forNodes == null) {this.forNodes = new ArrayList<ForNodeBuilder>();}
    for (ForNode item : items) {ForNodeBuilder builder = new ForNodeBuilder(item);_visitables.get("forNodes").add(builder);this.forNodes.add(builder);} return (A)this;
  }
  
  public A addAllToForNodes(Collection<ForNode> items) {
    if (this.forNodes == null) {this.forNodes = new ArrayList<ForNodeBuilder>();}
    for (ForNode item : items) {ForNodeBuilder builder = new ForNodeBuilder(item);_visitables.get("forNodes").add(builder);this.forNodes.add(builder);} return (A)this;
  }
  
  public A removeFromForNodes(io.fabric8.kubernetes.api.model.discovery.v1.ForNode... items) {
    if (this.forNodes == null) return (A)this;
    for (ForNode item : items) {ForNodeBuilder builder = new ForNodeBuilder(item);_visitables.get("forNodes").remove(builder); this.forNodes.remove(builder);} return (A)this;
  }
  
  public A removeAllFromForNodes(Collection<ForNode> items) {
    if (this.forNodes == null) return (A)this;
    for (ForNode item : items) {ForNodeBuilder builder = new ForNodeBuilder(item);_visitables.get("forNodes").remove(builder); this.forNodes.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromForNodes(Predicate<ForNodeBuilder> predicate) {
    if (forNodes == null) return (A) this;
    final Iterator<ForNodeBuilder> each = forNodes.iterator();
    final List visitables = _visitables.get("forNodes");
    while (each.hasNext()) {
      ForNodeBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<ForNode> buildForNodes() {
    return this.forNodes != null ? build(forNodes) : null;
  }
  
  public ForNode buildForNode(int index) {
    return this.forNodes.get(index).build();
  }
  
  public ForNode buildFirstForNode() {
    return this.forNodes.get(0).build();
  }
  
  public ForNode buildLastForNode() {
    return this.forNodes.get(forNodes.size() - 1).build();
  }
  
  public ForNode buildMatchingForNode(Predicate<ForNodeBuilder> predicate) {
      for (ForNodeBuilder item : forNodes) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingForNode(Predicate<ForNodeBuilder> predicate) {
      for (ForNodeBuilder item : forNodes) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withForNodes(List<ForNode> forNodes) {
    if (this.forNodes != null) {
      this._visitables.get("forNodes").clear();
    }
    if (forNodes != null) {
        this.forNodes = new ArrayList();
        for (ForNode item : forNodes) {
          this.addToForNodes(item);
        }
    } else {
      this.forNodes = null;
    }
    return (A) this;
  }
  
  public A withForNodes(io.fabric8.kubernetes.api.model.discovery.v1.ForNode... forNodes) {
    if (this.forNodes != null) {
        this.forNodes.clear();
        _visitables.remove("forNodes");
    }
    if (forNodes != null) {
      for (ForNode item : forNodes) {
        this.addToForNodes(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasForNodes() {
    return this.forNodes != null && !this.forNodes.isEmpty();
  }
  
  public A addNewForNode(String name) {
    return (A)addToForNodes(new ForNode(name));
  }
  
  public ForNodesNested<A> addNewForNode() {
    return new ForNodesNested(-1, null);
  }
  
  public ForNodesNested<A> addNewForNodeLike(ForNode item) {
    return new ForNodesNested(-1, item);
  }
  
  public ForNodesNested<A> setNewForNodeLike(int index,ForNode item) {
    return new ForNodesNested(index, item);
  }
  
  public ForNodesNested<A> editForNode(int index) {
    if (forNodes.size() <= index) throw new RuntimeException("Can't edit forNodes. Index exceeds size.");
    return setNewForNodeLike(index, buildForNode(index));
  }
  
  public ForNodesNested<A> editFirstForNode() {
    if (forNodes.size() == 0) throw new RuntimeException("Can't edit first forNodes. The list is empty.");
    return setNewForNodeLike(0, buildForNode(0));
  }
  
  public ForNodesNested<A> editLastForNode() {
    int index = forNodes.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last forNodes. The list is empty.");
    return setNewForNodeLike(index, buildForNode(index));
  }
  
  public ForNodesNested<A> editMatchingForNode(Predicate<ForNodeBuilder> predicate) {
    int index = -1;
    for (int i=0;i<forNodes.size();i++) { 
    if (predicate.test(forNodes.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching forNodes. No match found.");
    return setNewForNodeLike(index, buildForNode(index));
  }
  
  public A addToForZones(int index,ForZone item) {
    if (this.forZones == null) {this.forZones = new ArrayList<ForZoneBuilder>();}
    ForZoneBuilder builder = new ForZoneBuilder(item);
    if (index < 0 || index >= forZones.size()) {
        _visitables.get("forZones").add(builder);
        forZones.add(builder);
    } else {
        _visitables.get("forZones").add(builder);
        forZones.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToForZones(int index,ForZone item) {
    if (this.forZones == null) {this.forZones = new ArrayList<ForZoneBuilder>();}
    ForZoneBuilder builder = new ForZoneBuilder(item);
    if (index < 0 || index >= forZones.size()) {
        _visitables.get("forZones").add(builder);
        forZones.add(builder);
    } else {
        _visitables.get("forZones").add(builder);
        forZones.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToForZones(io.fabric8.kubernetes.api.model.discovery.v1.ForZone... items) {
    if (this.forZones == null) {this.forZones = new ArrayList<ForZoneBuilder>();}
    for (ForZone item : items) {ForZoneBuilder builder = new ForZoneBuilder(item);_visitables.get("forZones").add(builder);this.forZones.add(builder);} return (A)this;
  }
  
  public A addAllToForZones(Collection<ForZone> items) {
    if (this.forZones == null) {this.forZones = new ArrayList<ForZoneBuilder>();}
    for (ForZone item : items) {ForZoneBuilder builder = new ForZoneBuilder(item);_visitables.get("forZones").add(builder);this.forZones.add(builder);} return (A)this;
  }
  
  public A removeFromForZones(io.fabric8.kubernetes.api.model.discovery.v1.ForZone... items) {
    if (this.forZones == null) return (A)this;
    for (ForZone item : items) {ForZoneBuilder builder = new ForZoneBuilder(item);_visitables.get("forZones").remove(builder); this.forZones.remove(builder);} return (A)this;
  }
  
  public A removeAllFromForZones(Collection<ForZone> items) {
    if (this.forZones == null) return (A)this;
    for (ForZone item : items) {ForZoneBuilder builder = new ForZoneBuilder(item);_visitables.get("forZones").remove(builder); this.forZones.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromForZones(Predicate<ForZoneBuilder> predicate) {
    if (forZones == null) return (A) this;
    final Iterator<ForZoneBuilder> each = forZones.iterator();
    final List visitables = _visitables.get("forZones");
    while (each.hasNext()) {
      ForZoneBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<ForZone> buildForZones() {
    return this.forZones != null ? build(forZones) : null;
  }
  
  public ForZone buildForZone(int index) {
    return this.forZones.get(index).build();
  }
  
  public ForZone buildFirstForZone() {
    return this.forZones.get(0).build();
  }
  
  public ForZone buildLastForZone() {
    return this.forZones.get(forZones.size() - 1).build();
  }
  
  public ForZone buildMatchingForZone(Predicate<ForZoneBuilder> predicate) {
      for (ForZoneBuilder item : forZones) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingForZone(Predicate<ForZoneBuilder> predicate) {
      for (ForZoneBuilder item : forZones) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withForZones(List<ForZone> forZones) {
    if (this.forZones != null) {
      this._visitables.get("forZones").clear();
    }
    if (forZones != null) {
        this.forZones = new ArrayList();
        for (ForZone item : forZones) {
          this.addToForZones(item);
        }
    } else {
      this.forZones = null;
    }
    return (A) this;
  }
  
  public A withForZones(io.fabric8.kubernetes.api.model.discovery.v1.ForZone... forZones) {
    if (this.forZones != null) {
        this.forZones.clear();
        _visitables.remove("forZones");
    }
    if (forZones != null) {
      for (ForZone item : forZones) {
        this.addToForZones(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasForZones() {
    return this.forZones != null && !this.forZones.isEmpty();
  }
  
  public A addNewForZone(String name) {
    return (A)addToForZones(new ForZone(name));
  }
  
  public ForZonesNested<A> addNewForZone() {
    return new ForZonesNested(-1, null);
  }
  
  public ForZonesNested<A> addNewForZoneLike(ForZone item) {
    return new ForZonesNested(-1, item);
  }
  
  public ForZonesNested<A> setNewForZoneLike(int index,ForZone item) {
    return new ForZonesNested(index, item);
  }
  
  public ForZonesNested<A> editForZone(int index) {
    if (forZones.size() <= index) throw new RuntimeException("Can't edit forZones. Index exceeds size.");
    return setNewForZoneLike(index, buildForZone(index));
  }
  
  public ForZonesNested<A> editFirstForZone() {
    if (forZones.size() == 0) throw new RuntimeException("Can't edit first forZones. The list is empty.");
    return setNewForZoneLike(0, buildForZone(0));
  }
  
  public ForZonesNested<A> editLastForZone() {
    int index = forZones.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last forZones. The list is empty.");
    return setNewForZoneLike(index, buildForZone(index));
  }
  
  public ForZonesNested<A> editMatchingForZone(Predicate<ForZoneBuilder> predicate) {
    int index = -1;
    for (int i=0;i<forZones.size();i++) { 
    if (predicate.test(forZones.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching forZones. No match found.");
    return setNewForZoneLike(index, buildForZone(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    EndpointHintsFluent that = (EndpointHintsFluent) o;
    if (!java.util.Objects.equals(forNodes, that.forNodes)) return false;
    if (!java.util.Objects.equals(forZones, that.forZones)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(forNodes,  forZones,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (forNodes != null && !forNodes.isEmpty()) { sb.append("forNodes:"); sb.append(forNodes + ","); }
    if (forZones != null && !forZones.isEmpty()) { sb.append("forZones:"); sb.append(forZones + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ForNodesNested<N> extends ForNodeFluent<ForNodesNested<N>> implements Nested<N>{
    ForNodesNested(int index,ForNode item) {
      this.index = index;
      this.builder = new ForNodeBuilder(this, item);
    }
    ForNodeBuilder builder;
    int index;
    
    public N and() {
      return (N) EndpointHintsFluent.this.setToForNodes(index,builder.build());
    }
    
    public N endForNode() {
      return and();
    }
    
  
  }
  public class ForZonesNested<N> extends ForZoneFluent<ForZonesNested<N>> implements Nested<N>{
    ForZonesNested(int index,ForZone item) {
      this.index = index;
      this.builder = new ForZoneBuilder(this, item);
    }
    ForZoneBuilder builder;
    int index;
    
    public N and() {
      return (N) EndpointHintsFluent.this.setToForZones(index,builder.build());
    }
    
    public N endForZone() {
      return and();
    }
    
  
  }

}