
package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.extensions.DaemonSet;
import io.fabric8.kubernetes.api.model.extensions.DaemonSetList;
import io.fabric8.kubernetes.api.model.extensions.Deployment;
import io.fabric8.kubernetes.api.model.extensions.DeploymentList;
import io.fabric8.kubernetes.api.model.extensions.DeploymentRollback;
import io.fabric8.kubernetes.api.model.extensions.Ingress;
import io.fabric8.kubernetes.api.model.extensions.IngressList;
import io.fabric8.kubernetes.api.model.extensions.NetworkPolicy;
import io.fabric8.kubernetes.api.model.extensions.NetworkPolicyList;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSet;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSetList;
import io.fabric8.kubernetes.api.model.version.Info;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;

@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "APIGroup",
    "APIGroupList",
    "BaseKubernetesList",
    "CreateOptions",
    "DaemonSet",
    "DaemonSetList",
    "DeleteOptions",
    "Deployment",
    "DeploymentList",
    "DeploymentRollback",
    "GetOptions",
    "Info",
    "Ingress",
    "IngressList",
    "ListOptions",
    "NetworkPolicy",
    "NetworkPolicyList",
    "ObjectMeta",
    "ObjectReference",
    "Patch",
    "PatchOptions",
    "Quantity",
    "ReplicaSet",
    "ReplicaSetList",
    "RootPaths",
    "Status",
    "Time",
    "TypeMeta",
    "UpdateOptions"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = false, generateBuilderPackage = false, lazyCollectionInitEnabled = false, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(io.fabric8.kubernetes.api.model.ObjectMeta.class),
    @BuildableReference(LabelSelector.class),
    @BuildableReference(Container.class),
    @BuildableReference(PodTemplateSpec.class),
    @BuildableReference(ResourceRequirements.class),
    @BuildableReference(IntOrString.class),
    @BuildableReference(io.fabric8.kubernetes.api.model.ObjectReference.class),
    @BuildableReference(LocalObjectReference.class),
    @BuildableReference(PersistentVolumeClaim.class)
})
public class KubeSchema {

    /**
     * 
     * 
     */
    @JsonProperty("APIGroup")
    private APIGroup aPIGroup;
    /**
     * 
     * 
     */
    @JsonProperty("APIGroupList")
    private APIGroupList aPIGroupList;
    /**
     * 
     * 
     */
    @JsonProperty("BaseKubernetesList")
    private BaseKubernetesList baseKubernetesList;
    /**
     * 
     * 
     */
    @JsonProperty("CreateOptions")
    private CreateOptions createOptions;
    /**
     * 
     * 
     */
    @JsonProperty("DaemonSet")
    private DaemonSet daemonSet;
    /**
     * 
     * 
     */
    @JsonProperty("DaemonSetList")
    private DaemonSetList daemonSetList;
    /**
     * 
     * 
     */
    @JsonProperty("DeleteOptions")
    private DeleteOptions deleteOptions;
    /**
     * 
     * 
     */
    @JsonProperty("Deployment")
    private Deployment deployment;
    /**
     * 
     * 
     */
    @JsonProperty("DeploymentList")
    private DeploymentList deploymentList;
    /**
     * 
     * 
     */
    @JsonProperty("DeploymentRollback")
    private DeploymentRollback deploymentRollback;
    /**
     * 
     * 
     */
    @JsonProperty("GetOptions")
    private GetOptions getOptions;
    /**
     * 
     * 
     */
    @JsonProperty("Info")
    private Info info;
    /**
     * 
     * 
     */
    @JsonProperty("Ingress")
    private Ingress ingress;
    /**
     * 
     * 
     */
    @JsonProperty("IngressList")
    private IngressList ingressList;
    /**
     * 
     * 
     */
    @JsonProperty("ListOptions")
    private ListOptions listOptions;
    /**
     * 
     * 
     */
    @JsonProperty("NetworkPolicy")
    private NetworkPolicy networkPolicy;
    /**
     * 
     * 
     */
    @JsonProperty("NetworkPolicyList")
    private NetworkPolicyList networkPolicyList;
    /**
     * 
     * 
     */
    @JsonProperty("ObjectMeta")
    private io.fabric8.kubernetes.api.model.ObjectMeta objectMeta;
    /**
     * 
     * 
     */
    @JsonProperty("ObjectReference")
    private io.fabric8.kubernetes.api.model.ObjectReference objectReference;
    /**
     * 
     * 
     */
    @JsonProperty("Patch")
    private Patch patch;
    /**
     * 
     * 
     */
    @JsonProperty("PatchOptions")
    private PatchOptions patchOptions;
    /**
     * 
     * 
     */
    @JsonProperty("Quantity")
    private Quantity quantity;
    /**
     * 
     * 
     */
    @JsonProperty("ReplicaSet")
    private ReplicaSet replicaSet;
    /**
     * 
     * 
     */
    @JsonProperty("ReplicaSetList")
    private ReplicaSetList replicaSetList;
    /**
     * 
     * 
     */
    @JsonProperty("RootPaths")
    private RootPaths rootPaths;
    /**
     * 
     * 
     */
    @JsonProperty("Status")
    private Status status;
    /**
     * 
     * 
     */
    @JsonProperty("Time")
    private String time;
    /**
     * 
     * 
     */
    @JsonProperty("TypeMeta")
    private TypeMeta typeMeta;
    /**
     * 
     * 
     */
    @JsonProperty("UpdateOptions")
    private UpdateOptions updateOptions;
    @JsonIgnore
    private Map<java.lang.String, Object> additionalProperties = new HashMap<java.lang.String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public KubeSchema() {
    }

    /**
     * 
     * @param deploymentRollback
     * @param listOptions
     * @param aPIGroupList
     * @param ingressList
     * @param baseKubernetesList
     * @param updateOptions
     * @param daemonSet
     * @param daemonSetList
     * @param patch
     * @param rootPaths
     * @param replicaSetList
     * @param deployment
     * @param info
     * @param patchOptions
     * @param deleteOptions
     * @param quantity
     * @param networkPolicyList
     * @param networkPolicy
     * @param deploymentList
     * @param objectReference
     * @param replicaSet
     * @param createOptions
     * @param aPIGroup
     * @param ingress
     * @param typeMeta
     * @param objectMeta
     * @param getOptions
     * @param time
     * @param status
     */
    public KubeSchema(APIGroup aPIGroup, APIGroupList aPIGroupList, BaseKubernetesList baseKubernetesList, CreateOptions createOptions, DaemonSet daemonSet, DaemonSetList daemonSetList, DeleteOptions deleteOptions, Deployment deployment, DeploymentList deploymentList, DeploymentRollback deploymentRollback, GetOptions getOptions, Info info, Ingress ingress, IngressList ingressList, ListOptions listOptions, NetworkPolicy networkPolicy, NetworkPolicyList networkPolicyList, io.fabric8.kubernetes.api.model.ObjectMeta objectMeta, io.fabric8.kubernetes.api.model.ObjectReference objectReference, Patch patch, PatchOptions patchOptions, Quantity quantity, ReplicaSet replicaSet, ReplicaSetList replicaSetList, RootPaths rootPaths, Status status, String time, TypeMeta typeMeta, UpdateOptions updateOptions) {
        this.aPIGroup = aPIGroup;
        this.aPIGroupList = aPIGroupList;
        this.baseKubernetesList = baseKubernetesList;
        this.createOptions = createOptions;
        this.daemonSet = daemonSet;
        this.daemonSetList = daemonSetList;
        this.deleteOptions = deleteOptions;
        this.deployment = deployment;
        this.deploymentList = deploymentList;
        this.deploymentRollback = deploymentRollback;
        this.getOptions = getOptions;
        this.info = info;
        this.ingress = ingress;
        this.ingressList = ingressList;
        this.listOptions = listOptions;
        this.networkPolicy = networkPolicy;
        this.networkPolicyList = networkPolicyList;
        this.objectMeta = objectMeta;
        this.objectReference = objectReference;
        this.patch = patch;
        this.patchOptions = patchOptions;
        this.quantity = quantity;
        this.replicaSet = replicaSet;
        this.replicaSetList = replicaSetList;
        this.rootPaths = rootPaths;
        this.status = status;
        this.time = time;
        this.typeMeta = typeMeta;
        this.updateOptions = updateOptions;
    }

    /**
     * 
     * 
     * @return
     *     The aPIGroup
     */
    @JsonProperty("APIGroup")
    public APIGroup getAPIGroup() {
        return aPIGroup;
    }

    /**
     * 
     * 
     * @param aPIGroup
     *     The APIGroup
     */
    @JsonProperty("APIGroup")
    public void setAPIGroup(APIGroup aPIGroup) {
        this.aPIGroup = aPIGroup;
    }

    /**
     * 
     * 
     * @return
     *     The aPIGroupList
     */
    @JsonProperty("APIGroupList")
    public APIGroupList getAPIGroupList() {
        return aPIGroupList;
    }

    /**
     * 
     * 
     * @param aPIGroupList
     *     The APIGroupList
     */
    @JsonProperty("APIGroupList")
    public void setAPIGroupList(APIGroupList aPIGroupList) {
        this.aPIGroupList = aPIGroupList;
    }

    /**
     * 
     * 
     * @return
     *     The baseKubernetesList
     */
    @JsonProperty("BaseKubernetesList")
    public BaseKubernetesList getBaseKubernetesList() {
        return baseKubernetesList;
    }

    /**
     * 
     * 
     * @param baseKubernetesList
     *     The BaseKubernetesList
     */
    @JsonProperty("BaseKubernetesList")
    public void setBaseKubernetesList(BaseKubernetesList baseKubernetesList) {
        this.baseKubernetesList = baseKubernetesList;
    }

    /**
     * 
     * 
     * @return
     *     The createOptions
     */
    @JsonProperty("CreateOptions")
    public CreateOptions getCreateOptions() {
        return createOptions;
    }

    /**
     * 
     * 
     * @param createOptions
     *     The CreateOptions
     */
    @JsonProperty("CreateOptions")
    public void setCreateOptions(CreateOptions createOptions) {
        this.createOptions = createOptions;
    }

    /**
     * 
     * 
     * @return
     *     The daemonSet
     */
    @JsonProperty("DaemonSet")
    public DaemonSet getDaemonSet() {
        return daemonSet;
    }

    /**
     * 
     * 
     * @param daemonSet
     *     The DaemonSet
     */
    @JsonProperty("DaemonSet")
    public void setDaemonSet(DaemonSet daemonSet) {
        this.daemonSet = daemonSet;
    }

    /**
     * 
     * 
     * @return
     *     The daemonSetList
     */
    @JsonProperty("DaemonSetList")
    public DaemonSetList getDaemonSetList() {
        return daemonSetList;
    }

    /**
     * 
     * 
     * @param daemonSetList
     *     The DaemonSetList
     */
    @JsonProperty("DaemonSetList")
    public void setDaemonSetList(DaemonSetList daemonSetList) {
        this.daemonSetList = daemonSetList;
    }

    /**
     * 
     * 
     * @return
     *     The deleteOptions
     */
    @JsonProperty("DeleteOptions")
    public DeleteOptions getDeleteOptions() {
        return deleteOptions;
    }

    /**
     * 
     * 
     * @param deleteOptions
     *     The DeleteOptions
     */
    @JsonProperty("DeleteOptions")
    public void setDeleteOptions(DeleteOptions deleteOptions) {
        this.deleteOptions = deleteOptions;
    }

    /**
     * 
     * 
     * @return
     *     The deployment
     */
    @JsonProperty("Deployment")
    public Deployment getDeployment() {
        return deployment;
    }

    /**
     * 
     * 
     * @param deployment
     *     The Deployment
     */
    @JsonProperty("Deployment")
    public void setDeployment(Deployment deployment) {
        this.deployment = deployment;
    }

    /**
     * 
     * 
     * @return
     *     The deploymentList
     */
    @JsonProperty("DeploymentList")
    public DeploymentList getDeploymentList() {
        return deploymentList;
    }

    /**
     * 
     * 
     * @param deploymentList
     *     The DeploymentList
     */
    @JsonProperty("DeploymentList")
    public void setDeploymentList(DeploymentList deploymentList) {
        this.deploymentList = deploymentList;
    }

    /**
     * 
     * 
     * @return
     *     The deploymentRollback
     */
    @JsonProperty("DeploymentRollback")
    public DeploymentRollback getDeploymentRollback() {
        return deploymentRollback;
    }

    /**
     * 
     * 
     * @param deploymentRollback
     *     The DeploymentRollback
     */
    @JsonProperty("DeploymentRollback")
    public void setDeploymentRollback(DeploymentRollback deploymentRollback) {
        this.deploymentRollback = deploymentRollback;
    }

    /**
     * 
     * 
     * @return
     *     The getOptions
     */
    @JsonProperty("GetOptions")
    public GetOptions getGetOptions() {
        return getOptions;
    }

    /**
     * 
     * 
     * @param getOptions
     *     The GetOptions
     */
    @JsonProperty("GetOptions")
    public void setGetOptions(GetOptions getOptions) {
        this.getOptions = getOptions;
    }

    /**
     * 
     * 
     * @return
     *     The info
     */
    @JsonProperty("Info")
    public Info getInfo() {
        return info;
    }

    /**
     * 
     * 
     * @param info
     *     The Info
     */
    @JsonProperty("Info")
    public void setInfo(Info info) {
        this.info = info;
    }

    /**
     * 
     * 
     * @return
     *     The ingress
     */
    @JsonProperty("Ingress")
    public Ingress getIngress() {
        return ingress;
    }

    /**
     * 
     * 
     * @param ingress
     *     The Ingress
     */
    @JsonProperty("Ingress")
    public void setIngress(Ingress ingress) {
        this.ingress = ingress;
    }

    /**
     * 
     * 
     * @return
     *     The ingressList
     */
    @JsonProperty("IngressList")
    public IngressList getIngressList() {
        return ingressList;
    }

    /**
     * 
     * 
     * @param ingressList
     *     The IngressList
     */
    @JsonProperty("IngressList")
    public void setIngressList(IngressList ingressList) {
        this.ingressList = ingressList;
    }

    /**
     * 
     * 
     * @return
     *     The listOptions
     */
    @JsonProperty("ListOptions")
    public ListOptions getListOptions() {
        return listOptions;
    }

    /**
     * 
     * 
     * @param listOptions
     *     The ListOptions
     */
    @JsonProperty("ListOptions")
    public void setListOptions(ListOptions listOptions) {
        this.listOptions = listOptions;
    }

    /**
     * 
     * 
     * @return
     *     The networkPolicy
     */
    @JsonProperty("NetworkPolicy")
    public NetworkPolicy getNetworkPolicy() {
        return networkPolicy;
    }

    /**
     * 
     * 
     * @param networkPolicy
     *     The NetworkPolicy
     */
    @JsonProperty("NetworkPolicy")
    public void setNetworkPolicy(NetworkPolicy networkPolicy) {
        this.networkPolicy = networkPolicy;
    }

    /**
     * 
     * 
     * @return
     *     The networkPolicyList
     */
    @JsonProperty("NetworkPolicyList")
    public NetworkPolicyList getNetworkPolicyList() {
        return networkPolicyList;
    }

    /**
     * 
     * 
     * @param networkPolicyList
     *     The NetworkPolicyList
     */
    @JsonProperty("NetworkPolicyList")
    public void setNetworkPolicyList(NetworkPolicyList networkPolicyList) {
        this.networkPolicyList = networkPolicyList;
    }

    /**
     * 
     * 
     * @return
     *     The objectMeta
     */
    @JsonProperty("ObjectMeta")
    public io.fabric8.kubernetes.api.model.ObjectMeta getObjectMeta() {
        return objectMeta;
    }

    /**
     * 
     * 
     * @param objectMeta
     *     The ObjectMeta
     */
    @JsonProperty("ObjectMeta")
    public void setObjectMeta(io.fabric8.kubernetes.api.model.ObjectMeta objectMeta) {
        this.objectMeta = objectMeta;
    }

    /**
     * 
     * 
     * @return
     *     The objectReference
     */
    @JsonProperty("ObjectReference")
    public io.fabric8.kubernetes.api.model.ObjectReference getObjectReference() {
        return objectReference;
    }

    /**
     * 
     * 
     * @param objectReference
     *     The ObjectReference
     */
    @JsonProperty("ObjectReference")
    public void setObjectReference(io.fabric8.kubernetes.api.model.ObjectReference objectReference) {
        this.objectReference = objectReference;
    }

    /**
     * 
     * 
     * @return
     *     The patch
     */
    @JsonProperty("Patch")
    public Patch getPatch() {
        return patch;
    }

    /**
     * 
     * 
     * @param patch
     *     The Patch
     */
    @JsonProperty("Patch")
    public void setPatch(Patch patch) {
        this.patch = patch;
    }

    /**
     * 
     * 
     * @return
     *     The patchOptions
     */
    @JsonProperty("PatchOptions")
    public PatchOptions getPatchOptions() {
        return patchOptions;
    }

    /**
     * 
     * 
     * @param patchOptions
     *     The PatchOptions
     */
    @JsonProperty("PatchOptions")
    public void setPatchOptions(PatchOptions patchOptions) {
        this.patchOptions = patchOptions;
    }

    /**
     * 
     * 
     * @return
     *     The quantity
     */
    @JsonProperty("Quantity")
    public Quantity getQuantity() {
        return quantity;
    }

    /**
     * 
     * 
     * @param quantity
     *     The Quantity
     */
    @JsonProperty("Quantity")
    public void setQuantity(Quantity quantity) {
        this.quantity = quantity;
    }

    /**
     * 
     * 
     * @return
     *     The replicaSet
     */
    @JsonProperty("ReplicaSet")
    public ReplicaSet getReplicaSet() {
        return replicaSet;
    }

    /**
     * 
     * 
     * @param replicaSet
     *     The ReplicaSet
     */
    @JsonProperty("ReplicaSet")
    public void setReplicaSet(ReplicaSet replicaSet) {
        this.replicaSet = replicaSet;
    }

    /**
     * 
     * 
     * @return
     *     The replicaSetList
     */
    @JsonProperty("ReplicaSetList")
    public ReplicaSetList getReplicaSetList() {
        return replicaSetList;
    }

    /**
     * 
     * 
     * @param replicaSetList
     *     The ReplicaSetList
     */
    @JsonProperty("ReplicaSetList")
    public void setReplicaSetList(ReplicaSetList replicaSetList) {
        this.replicaSetList = replicaSetList;
    }

    /**
     * 
     * 
     * @return
     *     The rootPaths
     */
    @JsonProperty("RootPaths")
    public RootPaths getRootPaths() {
        return rootPaths;
    }

    /**
     * 
     * 
     * @param rootPaths
     *     The RootPaths
     */
    @JsonProperty("RootPaths")
    public void setRootPaths(RootPaths rootPaths) {
        this.rootPaths = rootPaths;
    }

    /**
     * 
     * 
     * @return
     *     The status
     */
    @JsonProperty("Status")
    public Status getStatus() {
        return status;
    }

    /**
     * 
     * 
     * @param status
     *     The Status
     */
    @JsonProperty("Status")
    public void setStatus(Status status) {
        this.status = status;
    }

    /**
     * 
     * 
     * @return
     *     The time
     */
    @JsonProperty("Time")
    public String getTime() {
        return time;
    }

    /**
     * 
     * 
     * @param time
     *     The Time
     */
    @JsonProperty("Time")
    public void setTime(String time) {
        this.time = time;
    }

    /**
     * 
     * 
     * @return
     *     The typeMeta
     */
    @JsonProperty("TypeMeta")
    public TypeMeta getTypeMeta() {
        return typeMeta;
    }

    /**
     * 
     * 
     * @param typeMeta
     *     The TypeMeta
     */
    @JsonProperty("TypeMeta")
    public void setTypeMeta(TypeMeta typeMeta) {
        this.typeMeta = typeMeta;
    }

    /**
     * 
     * 
     * @return
     *     The updateOptions
     */
    @JsonProperty("UpdateOptions")
    public UpdateOptions getUpdateOptions() {
        return updateOptions;
    }

    /**
     * 
     * 
     * @param updateOptions
     *     The UpdateOptions
     */
    @JsonProperty("UpdateOptions")
    public void setUpdateOptions(UpdateOptions updateOptions) {
        this.updateOptions = updateOptions;
    }

    @JsonAnyGetter
    public Map<java.lang.String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(java.lang.String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
