package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class IngressTLSBuilder extends io.fabric8.kubernetes.api.model.extensions.IngressTLSFluentImpl<io.fabric8.kubernetes.api.model.extensions.IngressTLSBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.extensions.IngressTLS,io.fabric8.kubernetes.api.model.extensions.IngressTLSBuilder>{
  public IngressTLSBuilder() {
    this(false);
  }
  public IngressTLSBuilder(java.lang.Boolean validationEnabled) {
    this(new IngressTLS(), validationEnabled);
  }
  public IngressTLSBuilder(io.fabric8.kubernetes.api.model.extensions.IngressTLSFluent<?> fluent) {
    this(fluent, false);
  }
  public IngressTLSBuilder(io.fabric8.kubernetes.api.model.extensions.IngressTLSFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new IngressTLS(), validationEnabled);
  }
  public IngressTLSBuilder(io.fabric8.kubernetes.api.model.extensions.IngressTLSFluent<?> fluent,io.fabric8.kubernetes.api.model.extensions.IngressTLS instance) {
    this(fluent, instance, false);
  }
  public IngressTLSBuilder(io.fabric8.kubernetes.api.model.extensions.IngressTLSFluent<?> fluent,io.fabric8.kubernetes.api.model.extensions.IngressTLS instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withHosts(instance.getHosts()); 
    fluent.withSecretName(instance.getSecretName()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public IngressTLSBuilder(io.fabric8.kubernetes.api.model.extensions.IngressTLS instance) {
    this(instance,false);
  }
  public IngressTLSBuilder(io.fabric8.kubernetes.api.model.extensions.IngressTLS instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withHosts(instance.getHosts()); 
    this.withSecretName(instance.getSecretName()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.extensions.IngressTLSFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.extensions.IngressTLS build() {
    IngressTLS buildable = new IngressTLS(fluent.getHosts(),fluent.getSecretName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    IngressTLSBuilder that = (IngressTLSBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}