package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class ReplicaSetSpecBuilder extends io.fabric8.kubernetes.api.model.extensions.ReplicaSetSpecFluentImpl<io.fabric8.kubernetes.api.model.extensions.ReplicaSetSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.extensions.ReplicaSetSpec,io.fabric8.kubernetes.api.model.extensions.ReplicaSetSpecBuilder>{
  public ReplicaSetSpecBuilder() {
    this(false);
  }
  public ReplicaSetSpecBuilder(java.lang.Boolean validationEnabled) {
    this(new ReplicaSetSpec(), validationEnabled);
  }
  public ReplicaSetSpecBuilder(io.fabric8.kubernetes.api.model.extensions.ReplicaSetSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ReplicaSetSpecBuilder(io.fabric8.kubernetes.api.model.extensions.ReplicaSetSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ReplicaSetSpec(), validationEnabled);
  }
  public ReplicaSetSpecBuilder(io.fabric8.kubernetes.api.model.extensions.ReplicaSetSpecFluent<?> fluent,io.fabric8.kubernetes.api.model.extensions.ReplicaSetSpec instance) {
    this(fluent, instance, false);
  }
  public ReplicaSetSpecBuilder(io.fabric8.kubernetes.api.model.extensions.ReplicaSetSpecFluent<?> fluent,io.fabric8.kubernetes.api.model.extensions.ReplicaSetSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withMinReadySeconds(instance.getMinReadySeconds()); 
    fluent.withReplicas(instance.getReplicas()); 
    fluent.withSelector(instance.getSelector()); 
    fluent.withTemplate(instance.getTemplate()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ReplicaSetSpecBuilder(io.fabric8.kubernetes.api.model.extensions.ReplicaSetSpec instance) {
    this(instance,false);
  }
  public ReplicaSetSpecBuilder(io.fabric8.kubernetes.api.model.extensions.ReplicaSetSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withMinReadySeconds(instance.getMinReadySeconds()); 
    this.withReplicas(instance.getReplicas()); 
    this.withSelector(instance.getSelector()); 
    this.withTemplate(instance.getTemplate()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.extensions.ReplicaSetSpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.extensions.ReplicaSetSpec build() {
    ReplicaSetSpec buildable = new ReplicaSetSpec(fluent.getMinReadySeconds(),fluent.getReplicas(),fluent.getSelector(),fluent.getTemplate());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ReplicaSetSpecBuilder that = (ReplicaSetSpecBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}