package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class HTTPIngressRuleValueBuilder extends io.fabric8.kubernetes.api.model.extensions.HTTPIngressRuleValueFluentImpl<io.fabric8.kubernetes.api.model.extensions.HTTPIngressRuleValueBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.extensions.HTTPIngressRuleValue,io.fabric8.kubernetes.api.model.extensions.HTTPIngressRuleValueBuilder> {

    io.fabric8.kubernetes.api.model.extensions.HTTPIngressRuleValueFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public HTTPIngressRuleValueBuilder() {
        this(true);
    }

    public HTTPIngressRuleValueBuilder(java.lang.Boolean validationEnabled) {
        this(new HTTPIngressRuleValue(), validationEnabled);
    }

    public HTTPIngressRuleValueBuilder(io.fabric8.kubernetes.api.model.extensions.HTTPIngressRuleValueFluent<?> fluent) {
        this(fluent, true);
    }

    public HTTPIngressRuleValueBuilder(io.fabric8.kubernetes.api.model.extensions.HTTPIngressRuleValueFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new HTTPIngressRuleValue(), validationEnabled);
    }

    public HTTPIngressRuleValueBuilder(io.fabric8.kubernetes.api.model.extensions.HTTPIngressRuleValueFluent<?> fluent,io.fabric8.kubernetes.api.model.extensions.HTTPIngressRuleValue instance) {
        this(fluent, instance, true);
    }

    public HTTPIngressRuleValueBuilder(io.fabric8.kubernetes.api.model.extensions.HTTPIngressRuleValueFluent<?> fluent,io.fabric8.kubernetes.api.model.extensions.HTTPIngressRuleValue instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withPaths(instance.getPaths()); 
        this.validationEnabled = validationEnabled; 
    }

    public HTTPIngressRuleValueBuilder(io.fabric8.kubernetes.api.model.extensions.HTTPIngressRuleValue instance) {
        this(instance,true);
    }

    public HTTPIngressRuleValueBuilder(io.fabric8.kubernetes.api.model.extensions.HTTPIngressRuleValue instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withPaths(instance.getPaths()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.extensions.HTTPIngressRuleValue build() {
        HTTPIngressRuleValue buildable = new HTTPIngressRuleValue(fluent.getPaths());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        HTTPIngressRuleValueBuilder that = (HTTPIngressRuleValueBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
