package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class NetworkPolicyPeerBuilder extends io.fabric8.kubernetes.api.model.extensions.NetworkPolicyPeerFluentImpl<io.fabric8.kubernetes.api.model.extensions.NetworkPolicyPeerBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.extensions.NetworkPolicyPeer,io.fabric8.kubernetes.api.model.extensions.NetworkPolicyPeerBuilder> {

    io.fabric8.kubernetes.api.model.extensions.NetworkPolicyPeerFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public NetworkPolicyPeerBuilder() {
        this(true);
    }

    public NetworkPolicyPeerBuilder(java.lang.Boolean validationEnabled) {
        this(new NetworkPolicyPeer(), validationEnabled);
    }

    public NetworkPolicyPeerBuilder(io.fabric8.kubernetes.api.model.extensions.NetworkPolicyPeerFluent<?> fluent) {
        this(fluent, true);
    }

    public NetworkPolicyPeerBuilder(io.fabric8.kubernetes.api.model.extensions.NetworkPolicyPeerFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new NetworkPolicyPeer(), validationEnabled);
    }

    public NetworkPolicyPeerBuilder(io.fabric8.kubernetes.api.model.extensions.NetworkPolicyPeerFluent<?> fluent,io.fabric8.kubernetes.api.model.extensions.NetworkPolicyPeer instance) {
        this(fluent, instance, true);
    }

    public NetworkPolicyPeerBuilder(io.fabric8.kubernetes.api.model.extensions.NetworkPolicyPeerFluent<?> fluent,io.fabric8.kubernetes.api.model.extensions.NetworkPolicyPeer instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withIpBlock(instance.getIpBlock()); 
        fluent.withNamespaceSelector(instance.getNamespaceSelector()); 
        fluent.withPodSelector(instance.getPodSelector()); 
        this.validationEnabled = validationEnabled; 
    }

    public NetworkPolicyPeerBuilder(io.fabric8.kubernetes.api.model.extensions.NetworkPolicyPeer instance) {
        this(instance,true);
    }

    public NetworkPolicyPeerBuilder(io.fabric8.kubernetes.api.model.extensions.NetworkPolicyPeer instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withIpBlock(instance.getIpBlock()); 
        this.withNamespaceSelector(instance.getNamespaceSelector()); 
        this.withPodSelector(instance.getPodSelector()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.extensions.NetworkPolicyPeer build() {
        NetworkPolicyPeer buildable = new NetworkPolicyPeer(fluent.getIpBlock(),fluent.getNamespaceSelector(),fluent.getPodSelector());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        NetworkPolicyPeerBuilder that = (NetworkPolicyPeerBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
