package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class IngressBackendBuilder extends io.fabric8.kubernetes.api.model.extensions.IngressBackendFluentImpl<io.fabric8.kubernetes.api.model.extensions.IngressBackendBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.extensions.IngressBackend,io.fabric8.kubernetes.api.model.extensions.IngressBackendBuilder> {

    io.fabric8.kubernetes.api.model.extensions.IngressBackendFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public IngressBackendBuilder() {
        this(true);
    }

    public IngressBackendBuilder(java.lang.Boolean validationEnabled) {
        this(new IngressBackend(), validationEnabled);
    }

    public IngressBackendBuilder(io.fabric8.kubernetes.api.model.extensions.IngressBackendFluent<?> fluent) {
        this(fluent, true);
    }

    public IngressBackendBuilder(io.fabric8.kubernetes.api.model.extensions.IngressBackendFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new IngressBackend(), validationEnabled);
    }

    public IngressBackendBuilder(io.fabric8.kubernetes.api.model.extensions.IngressBackendFluent<?> fluent,io.fabric8.kubernetes.api.model.extensions.IngressBackend instance) {
        this(fluent, instance, true);
    }

    public IngressBackendBuilder(io.fabric8.kubernetes.api.model.extensions.IngressBackendFluent<?> fluent,io.fabric8.kubernetes.api.model.extensions.IngressBackend instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withResource(instance.getResource()); 
        fluent.withServiceName(instance.getServiceName()); 
        fluent.withServicePort(instance.getServicePort()); 
        this.validationEnabled = validationEnabled; 
    }

    public IngressBackendBuilder(io.fabric8.kubernetes.api.model.extensions.IngressBackend instance) {
        this(instance,true);
    }

    public IngressBackendBuilder(io.fabric8.kubernetes.api.model.extensions.IngressBackend instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withResource(instance.getResource()); 
        this.withServiceName(instance.getServiceName()); 
        this.withServicePort(instance.getServicePort()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.extensions.IngressBackend build() {
        IngressBackend buildable = new IngressBackend(fluent.getResource(),fluent.getServiceName(),fluent.getServicePort());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        IngressBackendBuilder that = (IngressBackendBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
