package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.model.IntOrString;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.IntOrStringFluent;
import io.fabric8.kubernetes.api.model.IntOrStringBuilder;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class RollingUpdateDaemonSetFluent<A extends RollingUpdateDaemonSetFluent<A>> extends BaseFluent<A>{
  public RollingUpdateDaemonSetFluent() {
  }
  
  public RollingUpdateDaemonSetFluent(RollingUpdateDaemonSet instance) {
    this.copyInstance(instance);
  }
  private IntOrStringBuilder maxSurge;
  private IntOrStringBuilder maxUnavailable;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(RollingUpdateDaemonSet instance) {
    instance = (instance != null ? instance : new RollingUpdateDaemonSet());
    if (instance != null) {
          this.withMaxSurge(instance.getMaxSurge());
          this.withMaxUnavailable(instance.getMaxUnavailable());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public IntOrString buildMaxSurge() {
    return this.maxSurge != null ? this.maxSurge.build() : null;
  }
  
  public A withMaxSurge(IntOrString maxSurge) {
    this._visitables.remove("maxSurge");
    if (maxSurge != null) {
        this.maxSurge = new IntOrStringBuilder(maxSurge);
        this._visitables.get("maxSurge").add(this.maxSurge);
    } else {
        this.maxSurge = null;
        this._visitables.get("maxSurge").remove(this.maxSurge);
    }
    return (A) this;
  }
  
  public boolean hasMaxSurge() {
    return this.maxSurge != null;
  }
  
  public A withNewMaxSurge(Object value) {
    return (A)withMaxSurge(new IntOrString(value));
  }
  
  public MaxSurgeNested<A> withNewMaxSurge() {
    return new MaxSurgeNested(null);
  }
  
  public MaxSurgeNested<A> withNewMaxSurgeLike(IntOrString item) {
    return new MaxSurgeNested(item);
  }
  
  public MaxSurgeNested<A> editMaxSurge() {
    return withNewMaxSurgeLike(java.util.Optional.ofNullable(buildMaxSurge()).orElse(null));
  }
  
  public MaxSurgeNested<A> editOrNewMaxSurge() {
    return withNewMaxSurgeLike(java.util.Optional.ofNullable(buildMaxSurge()).orElse(new IntOrStringBuilder().build()));
  }
  
  public MaxSurgeNested<A> editOrNewMaxSurgeLike(IntOrString item) {
    return withNewMaxSurgeLike(java.util.Optional.ofNullable(buildMaxSurge()).orElse(item));
  }
  
  public IntOrString buildMaxUnavailable() {
    return this.maxUnavailable != null ? this.maxUnavailable.build() : null;
  }
  
  public A withMaxUnavailable(IntOrString maxUnavailable) {
    this._visitables.remove("maxUnavailable");
    if (maxUnavailable != null) {
        this.maxUnavailable = new IntOrStringBuilder(maxUnavailable);
        this._visitables.get("maxUnavailable").add(this.maxUnavailable);
    } else {
        this.maxUnavailable = null;
        this._visitables.get("maxUnavailable").remove(this.maxUnavailable);
    }
    return (A) this;
  }
  
  public boolean hasMaxUnavailable() {
    return this.maxUnavailable != null;
  }
  
  public A withNewMaxUnavailable(Object value) {
    return (A)withMaxUnavailable(new IntOrString(value));
  }
  
  public MaxUnavailableNested<A> withNewMaxUnavailable() {
    return new MaxUnavailableNested(null);
  }
  
  public MaxUnavailableNested<A> withNewMaxUnavailableLike(IntOrString item) {
    return new MaxUnavailableNested(item);
  }
  
  public MaxUnavailableNested<A> editMaxUnavailable() {
    return withNewMaxUnavailableLike(java.util.Optional.ofNullable(buildMaxUnavailable()).orElse(null));
  }
  
  public MaxUnavailableNested<A> editOrNewMaxUnavailable() {
    return withNewMaxUnavailableLike(java.util.Optional.ofNullable(buildMaxUnavailable()).orElse(new IntOrStringBuilder().build()));
  }
  
  public MaxUnavailableNested<A> editOrNewMaxUnavailableLike(IntOrString item) {
    return withNewMaxUnavailableLike(java.util.Optional.ofNullable(buildMaxUnavailable()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    RollingUpdateDaemonSetFluent that = (RollingUpdateDaemonSetFluent) o;
    if (!java.util.Objects.equals(maxSurge, that.maxSurge)) return false;
    if (!java.util.Objects.equals(maxUnavailable, that.maxUnavailable)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(maxSurge,  maxUnavailable,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (maxSurge != null) { sb.append("maxSurge:"); sb.append(maxSurge + ","); }
    if (maxUnavailable != null) { sb.append("maxUnavailable:"); sb.append(maxUnavailable + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class MaxSurgeNested<N> extends IntOrStringFluent<MaxSurgeNested<N>> implements Nested<N>{
    MaxSurgeNested(IntOrString item) {
      this.builder = new IntOrStringBuilder(this, item);
    }
    IntOrStringBuilder builder;
    
    public N and() {
      return (N) RollingUpdateDaemonSetFluent.this.withMaxSurge(builder.build());
    }
    
    public N endMaxSurge() {
      return and();
    }
    
  
  }
  public class MaxUnavailableNested<N> extends IntOrStringFluent<MaxUnavailableNested<N>> implements Nested<N>{
    MaxUnavailableNested(IntOrString item) {
      this.builder = new IntOrStringBuilder(this, item);
    }
    IntOrStringBuilder builder;
    
    public N and() {
      return (N) RollingUpdateDaemonSetFluent.this.withMaxUnavailable(builder.build());
    }
    
    public N endMaxUnavailable() {
      return and();
    }
    
  
  }

}