package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface DaemonSetListFluent<A extends DaemonSetListFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public A addToItems(int index,DaemonSet item);
  public A setToItems(int index,DaemonSet item);
  public A addToItems(io.fabric8.kubernetes.api.model.extensions.DaemonSet... items);
  public A addAllToItems(Collection<DaemonSet> items);
  public A removeFromItems(io.fabric8.kubernetes.api.model.extensions.DaemonSet... items);
  public A removeAllFromItems(Collection<DaemonSet> items);
  public A removeMatchingFromItems(Predicate<DaemonSetBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildItems instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<DaemonSet> getItems();
  public List<DaemonSet> buildItems();
  public DaemonSet buildItem(int index);
  public DaemonSet buildFirstItem();
  public DaemonSet buildLastItem();
  public DaemonSet buildMatchingItem(Predicate<DaemonSetBuilder> predicate);
  public Boolean hasMatchingItem(Predicate<DaemonSetBuilder> predicate);
  public A withItems(List<DaemonSet> items);
  public A withItems(io.fabric8.kubernetes.api.model.extensions.DaemonSet... items);
  public Boolean hasItems();
  public DaemonSetListFluent.ItemsNested<A> addNewItem();
  public DaemonSetListFluent.ItemsNested<A> addNewItemLike(DaemonSet item);
  public DaemonSetListFluent.ItemsNested<A> setNewItemLike(int index,DaemonSet item);
  public DaemonSetListFluent.ItemsNested<A> editItem(int index);
  public DaemonSetListFluent.ItemsNested<A> editFirstItem();
  public DaemonSetListFluent.ItemsNested<A> editLastItem();
  public DaemonSetListFluent.ItemsNested<A> editMatchingItem(Predicate<DaemonSetBuilder> predicate);
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  public ListMeta getMetadata();
  public A withMetadata(ListMeta metadata);
  public Boolean hasMetadata();
  public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface ItemsNested<N> extends Nested<N>,DaemonSetFluent<DaemonSetListFluent.ItemsNested<N>>{
    public N and();
    public N endItem();
    
  }
  
}