package io.fabric8.kubernetes.api.model.extensions;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.TypedLocalObjectReference;
import java.lang.String;
import io.fabric8.kubernetes.api.model.IntOrStringFluent;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface IngressBackendFluent<A extends IngressBackendFluent<A>> extends Fluent<A>{
  public TypedLocalObjectReference getResource();
  public A withResource(TypedLocalObjectReference resource);
  public Boolean hasResource();
  public A withNewResource(String apiGroup,String kind,String name);
  public String getServiceName();
  public A withServiceName(String serviceName);
  public Boolean hasServiceName();
  
  /**
   * This method has been deprecated, please use method buildServicePort instead.
   * @return The buildable object.
   */
  @Deprecated
  public IntOrString getServicePort();
  public IntOrString buildServicePort();
  public A withServicePort(IntOrString servicePort);
  public Boolean hasServicePort();
  public A withNewServicePort(Object value);
  public IngressBackendFluent.ServicePortNested<A> withNewServicePort();
  public IngressBackendFluent.ServicePortNested<A> withNewServicePortLike(IntOrString item);
  public IngressBackendFluent.ServicePortNested<A> editServicePort();
  public IngressBackendFluent.ServicePortNested<A> editOrNewServicePort();
  public IngressBackendFluent.ServicePortNested<A> editOrNewServicePortLike(IntOrString item);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface ServicePortNested<N> extends Nested<N>,IntOrStringFluent<IngressBackendFluent.ServicePortNested<N>>{
    public N and();
    public N endServicePort();
    
  }
  
}