package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IngressBuilder extends IngressFluentImpl<IngressBuilder> implements VisitableBuilder<Ingress,IngressBuilder>{
  public IngressBuilder() {
    this(false);
  }
  public IngressBuilder(Boolean validationEnabled) {
    this(new Ingress(), validationEnabled);
  }
  public IngressBuilder(IngressFluent<?> fluent) {
    this(fluent, false);
  }
  public IngressBuilder(IngressFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Ingress(), validationEnabled);
  }
  public IngressBuilder(IngressFluent<?> fluent,Ingress instance) {
    this(fluent, instance, false);
  }
  public IngressBuilder(IngressFluent<?> fluent,Ingress instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public IngressBuilder(Ingress instance) {
    this(instance,false);
  }
  public IngressBuilder(Ingress instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  IngressFluent<?> fluent;
  Boolean validationEnabled;
  public Ingress build() {
    Ingress buildable = new Ingress(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}