package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface IngressLoadBalancerIngressFluent<A extends IngressLoadBalancerIngressFluent<A>> extends Fluent<A>{
  public String getHostname();
  public A withHostname(String hostname);
  public Boolean hasHostname();
  public String getIp();
  public A withIp(String ip);
  public Boolean hasIp();
  public A addToPorts(int index,IngressPortStatus item);
  public A setToPorts(int index,IngressPortStatus item);
  public A addToPorts(io.fabric8.kubernetes.api.model.extensions.IngressPortStatus... items);
  public A addAllToPorts(Collection<IngressPortStatus> items);
  public A removeFromPorts(io.fabric8.kubernetes.api.model.extensions.IngressPortStatus... items);
  public A removeAllFromPorts(Collection<IngressPortStatus> items);
  public A removeMatchingFromPorts(Predicate<IngressPortStatusBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildPorts instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<IngressPortStatus> getPorts();
  public List<IngressPortStatus> buildPorts();
  public IngressPortStatus buildPort(int index);
  public IngressPortStatus buildFirstPort();
  public IngressPortStatus buildLastPort();
  public IngressPortStatus buildMatchingPort(Predicate<IngressPortStatusBuilder> predicate);
  public Boolean hasMatchingPort(Predicate<IngressPortStatusBuilder> predicate);
  public A withPorts(List<IngressPortStatus> ports);
  public A withPorts(io.fabric8.kubernetes.api.model.extensions.IngressPortStatus... ports);
  public Boolean hasPorts();
  public A addNewPort(String error,Integer port,String protocol);
  public IngressLoadBalancerIngressFluent.PortsNested<A> addNewPort();
  public IngressLoadBalancerIngressFluent.PortsNested<A> addNewPortLike(IngressPortStatus item);
  public IngressLoadBalancerIngressFluent.PortsNested<A> setNewPortLike(int index,IngressPortStatus item);
  public IngressLoadBalancerIngressFluent.PortsNested<A> editPort(int index);
  public IngressLoadBalancerIngressFluent.PortsNested<A> editFirstPort();
  public IngressLoadBalancerIngressFluent.PortsNested<A> editLastPort();
  public IngressLoadBalancerIngressFluent.PortsNested<A> editMatchingPort(Predicate<IngressPortStatusBuilder> predicate);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface PortsNested<N> extends Nested<N>,IngressPortStatusFluent<IngressLoadBalancerIngressFluent.PortsNested<N>>{
    public N and();
    public N endPort();
    
  }
  
}