package io.fabric8.kubernetes.api.model.extensions;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.IntOrStringFluent;
import java.util.LinkedHashMap;
import java.lang.Integer;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface NetworkPolicyPortFluent<A extends NetworkPolicyPortFluent<A>> extends Fluent<A>{
  public Integer getEndPort();
  public A withEndPort(Integer endPort);
  public Boolean hasEndPort();
  
  /**
   * This method has been deprecated, please use method buildPort instead.
   * @return The buildable object.
   */
  @Deprecated
  public IntOrString getPort();
  public IntOrString buildPort();
  public A withPort(IntOrString port);
  public Boolean hasPort();
  public A withNewPort(Object value);
  public NetworkPolicyPortFluent.PortNested<A> withNewPort();
  public NetworkPolicyPortFluent.PortNested<A> withNewPortLike(IntOrString item);
  public NetworkPolicyPortFluent.PortNested<A> editPort();
  public NetworkPolicyPortFluent.PortNested<A> editOrNewPort();
  public NetworkPolicyPortFluent.PortNested<A> editOrNewPortLike(IntOrString item);
  public String getProtocol();
  public A withProtocol(String protocol);
  public Boolean hasProtocol();
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface PortNested<N> extends Nested<N>,IntOrStringFluent<NetworkPolicyPortFluent.PortNested<N>>{
    public N and();
    public N endPort();
    
  }
  
}