package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NetworkPolicyPeerBuilder extends NetworkPolicyPeerFluent<NetworkPolicyPeerBuilder> implements VisitableBuilder<NetworkPolicyPeer,NetworkPolicyPeerBuilder>{
  public NetworkPolicyPeerBuilder() {
    this(false);
  }
  public NetworkPolicyPeerBuilder(Boolean validationEnabled) {
    this(new NetworkPolicyPeer(), validationEnabled);
  }
  public NetworkPolicyPeerBuilder(NetworkPolicyPeerFluent<?> fluent) {
    this(fluent, false);
  }
  public NetworkPolicyPeerBuilder(NetworkPolicyPeerFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new NetworkPolicyPeer(), validationEnabled);
  }
  public NetworkPolicyPeerBuilder(NetworkPolicyPeerFluent<?> fluent,NetworkPolicyPeer instance) {
    this(fluent, instance, false);
  }
  public NetworkPolicyPeerBuilder(NetworkPolicyPeerFluent<?> fluent,NetworkPolicyPeer instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new NetworkPolicyPeer());

    if (instance != null) {
      fluent.withIpBlock(instance.getIpBlock());
      fluent.withNamespaceSelector(instance.getNamespaceSelector());
      fluent.withPodSelector(instance.getPodSelector());
      fluent.withIpBlock(instance.getIpBlock());
      fluent.withNamespaceSelector(instance.getNamespaceSelector());
      fluent.withPodSelector(instance.getPodSelector());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public NetworkPolicyPeerBuilder(NetworkPolicyPeer instance) {
    this(instance,false);
  }
  public NetworkPolicyPeerBuilder(NetworkPolicyPeer instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new NetworkPolicyPeer());

    if (instance != null) {
      this.withIpBlock(instance.getIpBlock());
      this.withNamespaceSelector(instance.getNamespaceSelector());
      this.withPodSelector(instance.getPodSelector());
      this.withIpBlock(instance.getIpBlock());
      this.withNamespaceSelector(instance.getNamespaceSelector());
      this.withPodSelector(instance.getPodSelector());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  NetworkPolicyPeerFluent<?> fluent;
  Boolean validationEnabled;
  public NetworkPolicyPeer build() {
    NetworkPolicyPeer buildable = new NetworkPolicyPeer(fluent.buildIpBlock(),fluent.buildNamespaceSelector(),fluent.buildPodSelector());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}