package io.fabric8.kubernetes.api.model.internal.apiserver.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class StorageVersionStatusFluent<A extends StorageVersionStatusFluent<A>> extends BaseFluent<A>{
  public StorageVersionStatusFluent() {
  }
  
  public StorageVersionStatusFluent(StorageVersionStatus instance) {
    this.copyInstance(instance);
  }
  private String commonEncodingVersion;
  private ArrayList<StorageVersionConditionBuilder> conditions = new ArrayList<StorageVersionConditionBuilder>();
  private ArrayList<ServerStorageVersionBuilder> storageVersions = new ArrayList<ServerStorageVersionBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(StorageVersionStatus instance) {
    instance = (instance != null ? instance : new StorageVersionStatus());
    if (instance != null) {
          this.withCommonEncodingVersion(instance.getCommonEncodingVersion());
          this.withConditions(instance.getConditions());
          this.withStorageVersions(instance.getStorageVersions());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getCommonEncodingVersion() {
    return this.commonEncodingVersion;
  }
  
  public A withCommonEncodingVersion(String commonEncodingVersion) {
    this.commonEncodingVersion = commonEncodingVersion;
    return (A) this;
  }
  
  public boolean hasCommonEncodingVersion() {
    return this.commonEncodingVersion != null;
  }
  
  public A addToConditions(int index,StorageVersionCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<StorageVersionConditionBuilder>();}
    StorageVersionConditionBuilder builder = new StorageVersionConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").add(index, builder); conditions.add(index, builder);}
    return (A)this;
  }
  
  public A setToConditions(int index,StorageVersionCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<StorageVersionConditionBuilder>();}
    StorageVersionConditionBuilder builder = new StorageVersionConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").set(index, builder); conditions.set(index, builder);}
    return (A)this;
  }
  
  public A addToConditions(io.fabric8.kubernetes.api.model.internal.apiserver.v1alpha1.StorageVersionCondition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<StorageVersionConditionBuilder>();}
    for (StorageVersionCondition item : items) {StorageVersionConditionBuilder builder = new StorageVersionConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  
  public A addAllToConditions(Collection<StorageVersionCondition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<StorageVersionConditionBuilder>();}
    for (StorageVersionCondition item : items) {StorageVersionConditionBuilder builder = new StorageVersionConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  
  public A removeFromConditions(io.fabric8.kubernetes.api.model.internal.apiserver.v1alpha1.StorageVersionCondition... items) {
    if (this.conditions == null) return (A)this;
    for (StorageVersionCondition item : items) {StorageVersionConditionBuilder builder = new StorageVersionConditionBuilder(item);_visitables.get("conditions").remove(builder); this.conditions.remove(builder);} return (A)this;
  }
  
  public A removeAllFromConditions(Collection<StorageVersionCondition> items) {
    if (this.conditions == null) return (A)this;
    for (StorageVersionCondition item : items) {StorageVersionConditionBuilder builder = new StorageVersionConditionBuilder(item);_visitables.get("conditions").remove(builder); this.conditions.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromConditions(Predicate<StorageVersionConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<StorageVersionConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      StorageVersionConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<StorageVersionCondition> buildConditions() {
    return this.conditions != null ? build(conditions) : null;
  }
  
  public StorageVersionCondition buildCondition(int index) {
    return this.conditions.get(index).build();
  }
  
  public StorageVersionCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  
  public StorageVersionCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  
  public StorageVersionCondition buildMatchingCondition(Predicate<StorageVersionConditionBuilder> predicate) {
      for (StorageVersionConditionBuilder item : conditions) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingCondition(Predicate<StorageVersionConditionBuilder> predicate) {
      for (StorageVersionConditionBuilder item : conditions) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withConditions(List<StorageVersionCondition> conditions) {
    if (this.conditions != null) {
      this._visitables.get("conditions").clear();
    }
    if (conditions != null) {
        this.conditions = new ArrayList();
        for (StorageVersionCondition item : conditions) {
          this.addToConditions(item);
        }
    } else {
      this.conditions = null;
    }
    return (A) this;
  }
  
  public A withConditions(io.fabric8.kubernetes.api.model.internal.apiserver.v1alpha1.StorageVersionCondition... conditions) {
    if (this.conditions != null) {
        this.conditions.clear();
        _visitables.remove("conditions");
    }
    if (conditions != null) {
      for (StorageVersionCondition item : conditions) {
        this.addToConditions(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasConditions() {
    return this.conditions != null && !this.conditions.isEmpty();
  }
  
  public ConditionsNested<A> addNewCondition() {
    return new ConditionsNested(-1, null);
  }
  
  public ConditionsNested<A> addNewConditionLike(StorageVersionCondition item) {
    return new ConditionsNested(-1, item);
  }
  
  public ConditionsNested<A> setNewConditionLike(int index,StorageVersionCondition item) {
    return new ConditionsNested(index, item);
  }
  
  public ConditionsNested<A> editCondition(int index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  public ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  
  public ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  public ConditionsNested<A> editMatchingCondition(Predicate<StorageVersionConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  public A addToStorageVersions(int index,ServerStorageVersion item) {
    if (this.storageVersions == null) {this.storageVersions = new ArrayList<ServerStorageVersionBuilder>();}
    ServerStorageVersionBuilder builder = new ServerStorageVersionBuilder(item);
    if (index < 0 || index >= storageVersions.size()) { _visitables.get("storageVersions").add(builder); storageVersions.add(builder); } else { _visitables.get("storageVersions").add(index, builder); storageVersions.add(index, builder);}
    return (A)this;
  }
  
  public A setToStorageVersions(int index,ServerStorageVersion item) {
    if (this.storageVersions == null) {this.storageVersions = new ArrayList<ServerStorageVersionBuilder>();}
    ServerStorageVersionBuilder builder = new ServerStorageVersionBuilder(item);
    if (index < 0 || index >= storageVersions.size()) { _visitables.get("storageVersions").add(builder); storageVersions.add(builder); } else { _visitables.get("storageVersions").set(index, builder); storageVersions.set(index, builder);}
    return (A)this;
  }
  
  public A addToStorageVersions(io.fabric8.kubernetes.api.model.internal.apiserver.v1alpha1.ServerStorageVersion... items) {
    if (this.storageVersions == null) {this.storageVersions = new ArrayList<ServerStorageVersionBuilder>();}
    for (ServerStorageVersion item : items) {ServerStorageVersionBuilder builder = new ServerStorageVersionBuilder(item);_visitables.get("storageVersions").add(builder);this.storageVersions.add(builder);} return (A)this;
  }
  
  public A addAllToStorageVersions(Collection<ServerStorageVersion> items) {
    if (this.storageVersions == null) {this.storageVersions = new ArrayList<ServerStorageVersionBuilder>();}
    for (ServerStorageVersion item : items) {ServerStorageVersionBuilder builder = new ServerStorageVersionBuilder(item);_visitables.get("storageVersions").add(builder);this.storageVersions.add(builder);} return (A)this;
  }
  
  public A removeFromStorageVersions(io.fabric8.kubernetes.api.model.internal.apiserver.v1alpha1.ServerStorageVersion... items) {
    if (this.storageVersions == null) return (A)this;
    for (ServerStorageVersion item : items) {ServerStorageVersionBuilder builder = new ServerStorageVersionBuilder(item);_visitables.get("storageVersions").remove(builder); this.storageVersions.remove(builder);} return (A)this;
  }
  
  public A removeAllFromStorageVersions(Collection<ServerStorageVersion> items) {
    if (this.storageVersions == null) return (A)this;
    for (ServerStorageVersion item : items) {ServerStorageVersionBuilder builder = new ServerStorageVersionBuilder(item);_visitables.get("storageVersions").remove(builder); this.storageVersions.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromStorageVersions(Predicate<ServerStorageVersionBuilder> predicate) {
    if (storageVersions == null) return (A) this;
    final Iterator<ServerStorageVersionBuilder> each = storageVersions.iterator();
    final List visitables = _visitables.get("storageVersions");
    while (each.hasNext()) {
      ServerStorageVersionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<ServerStorageVersion> buildStorageVersions() {
    return this.storageVersions != null ? build(storageVersions) : null;
  }
  
  public ServerStorageVersion buildStorageVersion(int index) {
    return this.storageVersions.get(index).build();
  }
  
  public ServerStorageVersion buildFirstStorageVersion() {
    return this.storageVersions.get(0).build();
  }
  
  public ServerStorageVersion buildLastStorageVersion() {
    return this.storageVersions.get(storageVersions.size() - 1).build();
  }
  
  public ServerStorageVersion buildMatchingStorageVersion(Predicate<ServerStorageVersionBuilder> predicate) {
      for (ServerStorageVersionBuilder item : storageVersions) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingStorageVersion(Predicate<ServerStorageVersionBuilder> predicate) {
      for (ServerStorageVersionBuilder item : storageVersions) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withStorageVersions(List<ServerStorageVersion> storageVersions) {
    if (this.storageVersions != null) {
      this._visitables.get("storageVersions").clear();
    }
    if (storageVersions != null) {
        this.storageVersions = new ArrayList();
        for (ServerStorageVersion item : storageVersions) {
          this.addToStorageVersions(item);
        }
    } else {
      this.storageVersions = null;
    }
    return (A) this;
  }
  
  public A withStorageVersions(io.fabric8.kubernetes.api.model.internal.apiserver.v1alpha1.ServerStorageVersion... storageVersions) {
    if (this.storageVersions != null) {
        this.storageVersions.clear();
        _visitables.remove("storageVersions");
    }
    if (storageVersions != null) {
      for (ServerStorageVersion item : storageVersions) {
        this.addToStorageVersions(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasStorageVersions() {
    return this.storageVersions != null && !this.storageVersions.isEmpty();
  }
  
  public StorageVersionsNested<A> addNewStorageVersion() {
    return new StorageVersionsNested(-1, null);
  }
  
  public StorageVersionsNested<A> addNewStorageVersionLike(ServerStorageVersion item) {
    return new StorageVersionsNested(-1, item);
  }
  
  public StorageVersionsNested<A> setNewStorageVersionLike(int index,ServerStorageVersion item) {
    return new StorageVersionsNested(index, item);
  }
  
  public StorageVersionsNested<A> editStorageVersion(int index) {
    if (storageVersions.size() <= index) throw new RuntimeException("Can't edit storageVersions. Index exceeds size.");
    return setNewStorageVersionLike(index, buildStorageVersion(index));
  }
  
  public StorageVersionsNested<A> editFirstStorageVersion() {
    if (storageVersions.size() == 0) throw new RuntimeException("Can't edit first storageVersions. The list is empty.");
    return setNewStorageVersionLike(0, buildStorageVersion(0));
  }
  
  public StorageVersionsNested<A> editLastStorageVersion() {
    int index = storageVersions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last storageVersions. The list is empty.");
    return setNewStorageVersionLike(index, buildStorageVersion(index));
  }
  
  public StorageVersionsNested<A> editMatchingStorageVersion(Predicate<ServerStorageVersionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<storageVersions.size();i++) { 
    if (predicate.test(storageVersions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching storageVersions. No match found.");
    return setNewStorageVersionLike(index, buildStorageVersion(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    StorageVersionStatusFluent that = (StorageVersionStatusFluent) o;
    if (!java.util.Objects.equals(commonEncodingVersion, that.commonEncodingVersion)) return false;
    if (!java.util.Objects.equals(conditions, that.conditions)) return false;
    if (!java.util.Objects.equals(storageVersions, that.storageVersions)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(commonEncodingVersion,  conditions,  storageVersions,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (commonEncodingVersion != null) { sb.append("commonEncodingVersion:"); sb.append(commonEncodingVersion + ","); }
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (storageVersions != null && !storageVersions.isEmpty()) { sb.append("storageVersions:"); sb.append(storageVersions + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ConditionsNested<N> extends StorageVersionConditionFluent<ConditionsNested<N>> implements Nested<N>{
    ConditionsNested(int index,StorageVersionCondition item) {
      this.index = index;
      this.builder = new StorageVersionConditionBuilder(this, item);
    }
    StorageVersionConditionBuilder builder;
    int index;
    
    public N and() {
      return (N) StorageVersionStatusFluent.this.setToConditions(index,builder.build());
    }
    
    public N endCondition() {
      return and();
    }
    
  
  }
  public class StorageVersionsNested<N> extends ServerStorageVersionFluent<StorageVersionsNested<N>> implements Nested<N>{
    StorageVersionsNested(int index,ServerStorageVersion item) {
      this.index = index;
      this.builder = new ServerStorageVersionBuilder(this, item);
    }
    ServerStorageVersionBuilder builder;
    int index;
    
    public N and() {
      return (N) StorageVersionStatusFluent.this.setToStorageVersions(index,builder.build());
    }
    
    public N endStorageVersion() {
      return and();
    }
    
  
  }

}