/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.flowcontrol.v1beta3;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.flowcontrol.v1beta3.LimitResponse;
import io.fabric8.kubernetes.api.model.flowcontrol.v1beta3.LimitResponseBuilder;
import io.fabric8.kubernetes.api.model.flowcontrol.v1beta3.LimitResponseFluentImpl;
import io.fabric8.kubernetes.api.model.flowcontrol.v1beta3.LimitedPriorityLevelConfiguration;
import io.fabric8.kubernetes.api.model.flowcontrol.v1beta3.LimitedPriorityLevelConfigurationFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class LimitedPriorityLevelConfigurationFluentImpl<A extends LimitedPriorityLevelConfigurationFluent<A>>
extends BaseFluent<A>
implements LimitedPriorityLevelConfigurationFluent<A> {
    private Integer borrowingLimitPercent;
    private Integer lendablePercent;
    private LimitResponseBuilder limitResponse;
    private Integer nominalConcurrencyShares;
    private Map<String, Object> additionalProperties;

    public LimitedPriorityLevelConfigurationFluentImpl() {
    }

    public LimitedPriorityLevelConfigurationFluentImpl(LimitedPriorityLevelConfiguration instance) {
        this.withBorrowingLimitPercent(instance.getBorrowingLimitPercent());
        this.withLendablePercent(instance.getLendablePercent());
        this.withLimitResponse(instance.getLimitResponse());
        this.withNominalConcurrencyShares(instance.getNominalConcurrencyShares());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public Integer getBorrowingLimitPercent() {
        return this.borrowingLimitPercent;
    }

    @Override
    public A withBorrowingLimitPercent(Integer borrowingLimitPercent) {
        this.borrowingLimitPercent = borrowingLimitPercent;
        return (A)this;
    }

    @Override
    public Boolean hasBorrowingLimitPercent() {
        return this.borrowingLimitPercent != null;
    }

    @Override
    public Integer getLendablePercent() {
        return this.lendablePercent;
    }

    @Override
    public A withLendablePercent(Integer lendablePercent) {
        this.lendablePercent = lendablePercent;
        return (A)this;
    }

    @Override
    public Boolean hasLendablePercent() {
        return this.lendablePercent != null;
    }

    @Override
    @Deprecated
    public LimitResponse getLimitResponse() {
        return this.limitResponse != null ? this.limitResponse.build() : null;
    }

    @Override
    public LimitResponse buildLimitResponse() {
        return this.limitResponse != null ? this.limitResponse.build() : null;
    }

    @Override
    public A withLimitResponse(LimitResponse limitResponse) {
        this._visitables.get((Object)"limitResponse").remove(this.limitResponse);
        if (limitResponse != null) {
            this.limitResponse = new LimitResponseBuilder(limitResponse);
            this._visitables.get((Object)"limitResponse").add(this.limitResponse);
        } else {
            this.limitResponse = null;
            this._visitables.get((Object)"limitResponse").remove(this.limitResponse);
        }
        return (A)this;
    }

    @Override
    public Boolean hasLimitResponse() {
        return this.limitResponse != null;
    }

    @Override
    public LimitedPriorityLevelConfigurationFluent.LimitResponseNested<A> withNewLimitResponse() {
        return new LimitResponseNestedImpl();
    }

    @Override
    public LimitedPriorityLevelConfigurationFluent.LimitResponseNested<A> withNewLimitResponseLike(LimitResponse item) {
        return new LimitResponseNestedImpl(item);
    }

    @Override
    public LimitedPriorityLevelConfigurationFluent.LimitResponseNested<A> editLimitResponse() {
        return this.withNewLimitResponseLike(this.getLimitResponse());
    }

    @Override
    public LimitedPriorityLevelConfigurationFluent.LimitResponseNested<A> editOrNewLimitResponse() {
        return this.withNewLimitResponseLike(this.getLimitResponse() != null ? this.getLimitResponse() : new LimitResponseBuilder().build());
    }

    @Override
    public LimitedPriorityLevelConfigurationFluent.LimitResponseNested<A> editOrNewLimitResponseLike(LimitResponse item) {
        return this.withNewLimitResponseLike(this.getLimitResponse() != null ? this.getLimitResponse() : item);
    }

    @Override
    public Integer getNominalConcurrencyShares() {
        return this.nominalConcurrencyShares;
    }

    @Override
    public A withNominalConcurrencyShares(Integer nominalConcurrencyShares) {
        this.nominalConcurrencyShares = nominalConcurrencyShares;
        return (A)this;
    }

    @Override
    public Boolean hasNominalConcurrencyShares() {
        return this.nominalConcurrencyShares != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LimitedPriorityLevelConfigurationFluentImpl that = (LimitedPriorityLevelConfigurationFluentImpl)o;
        if (this.borrowingLimitPercent != null ? !this.borrowingLimitPercent.equals(that.borrowingLimitPercent) : that.borrowingLimitPercent != null) {
            return false;
        }
        if (this.lendablePercent != null ? !this.lendablePercent.equals(that.lendablePercent) : that.lendablePercent != null) {
            return false;
        }
        if (this.limitResponse != null ? !this.limitResponse.equals(that.limitResponse) : that.limitResponse != null) {
            return false;
        }
        if (this.nominalConcurrencyShares != null ? !this.nominalConcurrencyShares.equals(that.nominalConcurrencyShares) : that.nominalConcurrencyShares != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.borrowingLimitPercent, this.lendablePercent, this.limitResponse, this.nominalConcurrencyShares, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.borrowingLimitPercent != null) {
            sb.append("borrowingLimitPercent:");
            sb.append(this.borrowingLimitPercent + ",");
        }
        if (this.lendablePercent != null) {
            sb.append("lendablePercent:");
            sb.append(this.lendablePercent + ",");
        }
        if (this.limitResponse != null) {
            sb.append("limitResponse:");
            sb.append(this.limitResponse + ",");
        }
        if (this.nominalConcurrencyShares != null) {
            sb.append("nominalConcurrencyShares:");
            sb.append(this.nominalConcurrencyShares + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class LimitResponseNestedImpl<N>
    extends LimitResponseFluentImpl<LimitedPriorityLevelConfigurationFluent.LimitResponseNested<N>>
    implements LimitedPriorityLevelConfigurationFluent.LimitResponseNested<N>,
    Nested<N> {
        LimitResponseBuilder builder;

        LimitResponseNestedImpl(LimitResponse item) {
            this.builder = new LimitResponseBuilder(this, item);
        }

        LimitResponseNestedImpl() {
            this.builder = new LimitResponseBuilder(this);
        }

        @Override
        public N and() {
            return (N)LimitedPriorityLevelConfigurationFluentImpl.this.withLimitResponse(this.builder.build());
        }

        @Override
        public N endLimitResponse() {
            return this.and();
        }
    }
}

