package io.fabric8.kubernetes.api.model.flowcontrol.v1beta1;

import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ResourcePolicyRuleFluentImpl<A extends ResourcePolicyRuleFluent<A>> extends BaseFluent<A> implements ResourcePolicyRuleFluent<A>{
  public ResourcePolicyRuleFluentImpl() {
  }
  public ResourcePolicyRuleFluentImpl(ResourcePolicyRule instance) {
    if (instance != null) {
      this.withApiGroups(instance.getApiGroups());
      this.withClusterScope(instance.getClusterScope());
      this.withNamespaces(instance.getNamespaces());
      this.withResources(instance.getResources());
      this.withVerbs(instance.getVerbs());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private List<String> apiGroups = new ArrayList<String>();
  private Boolean clusterScope;
  private List<String> namespaces = new ArrayList<String>();
  private List<String> resources = new ArrayList<String>();
  private List<String> verbs = new ArrayList<String>();
  private Map<String,Object> additionalProperties;
  public A addToApiGroups(int index,String item) {
    if (this.apiGroups == null) {this.apiGroups = new ArrayList<String>();}
    this.apiGroups.add(index, item);
    return (A)this;
  }
  public A setToApiGroups(int index,String item) {
    if (this.apiGroups == null) {this.apiGroups = new ArrayList<String>();}
    this.apiGroups.set(index, item); return (A)this;
  }
  public A addToApiGroups(java.lang.String... items) {
    if (this.apiGroups == null) {this.apiGroups = new ArrayList<String>();}
    for (String item : items) {this.apiGroups.add(item);} return (A)this;
  }
  public A addAllToApiGroups(Collection<String> items) {
    if (this.apiGroups == null) {this.apiGroups = new ArrayList<String>();}
    for (String item : items) {this.apiGroups.add(item);} return (A)this;
  }
  public A removeFromApiGroups(java.lang.String... items) {
    for (String item : items) {if (this.apiGroups!= null){ this.apiGroups.remove(item);}} return (A)this;
  }
  public A removeAllFromApiGroups(Collection<String> items) {
    for (String item : items) {if (this.apiGroups!= null){ this.apiGroups.remove(item);}} return (A)this;
  }
  public List<String> getApiGroups() {
    return this.apiGroups;
  }
  public String getApiGroup(int index) {
    return this.apiGroups.get(index);
  }
  public String getFirstApiGroup() {
    return this.apiGroups.get(0);
  }
  public String getLastApiGroup() {
    return this.apiGroups.get(apiGroups.size() - 1);
  }
  public String getMatchingApiGroup(Predicate<String> predicate) {
    for (String item: apiGroups) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingApiGroup(Predicate<String> predicate) {
    for (String item: apiGroups) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withApiGroups(List<String> apiGroups) {
    if (apiGroups != null) {this.apiGroups = new ArrayList(); for (String item : apiGroups){this.addToApiGroups(item);}} else { this.apiGroups = null;} return (A) this;
  }
  public A withApiGroups(java.lang.String... apiGroups) {
    if (this.apiGroups != null) {this.apiGroups.clear(); _visitables.remove("apiGroups"); }
    if (apiGroups != null) {for (String item :apiGroups){ this.addToApiGroups(item);}} return (A) this;
  }
  public Boolean hasApiGroups() {
    return apiGroups != null && !apiGroups.isEmpty();
  }
  public Boolean getClusterScope() {
    return this.clusterScope;
  }
  public A withClusterScope(Boolean clusterScope) {
    this.clusterScope=clusterScope; return (A) this;
  }
  public Boolean hasClusterScope() {
    return this.clusterScope != null;
  }
  public A addToNamespaces(int index,String item) {
    if (this.namespaces == null) {this.namespaces = new ArrayList<String>();}
    this.namespaces.add(index, item);
    return (A)this;
  }
  public A setToNamespaces(int index,String item) {
    if (this.namespaces == null) {this.namespaces = new ArrayList<String>();}
    this.namespaces.set(index, item); return (A)this;
  }
  public A addToNamespaces(java.lang.String... items) {
    if (this.namespaces == null) {this.namespaces = new ArrayList<String>();}
    for (String item : items) {this.namespaces.add(item);} return (A)this;
  }
  public A addAllToNamespaces(Collection<String> items) {
    if (this.namespaces == null) {this.namespaces = new ArrayList<String>();}
    for (String item : items) {this.namespaces.add(item);} return (A)this;
  }
  public A removeFromNamespaces(java.lang.String... items) {
    for (String item : items) {if (this.namespaces!= null){ this.namespaces.remove(item);}} return (A)this;
  }
  public A removeAllFromNamespaces(Collection<String> items) {
    for (String item : items) {if (this.namespaces!= null){ this.namespaces.remove(item);}} return (A)this;
  }
  public List<String> getNamespaces() {
    return this.namespaces;
  }
  public String getNamespace(int index) {
    return this.namespaces.get(index);
  }
  public String getFirstNamespace() {
    return this.namespaces.get(0);
  }
  public String getLastNamespace() {
    return this.namespaces.get(namespaces.size() - 1);
  }
  public String getMatchingNamespace(Predicate<String> predicate) {
    for (String item: namespaces) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingNamespace(Predicate<String> predicate) {
    for (String item: namespaces) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withNamespaces(List<String> namespaces) {
    if (namespaces != null) {this.namespaces = new ArrayList(); for (String item : namespaces){this.addToNamespaces(item);}} else { this.namespaces = null;} return (A) this;
  }
  public A withNamespaces(java.lang.String... namespaces) {
    if (this.namespaces != null) {this.namespaces.clear(); _visitables.remove("namespaces"); }
    if (namespaces != null) {for (String item :namespaces){ this.addToNamespaces(item);}} return (A) this;
  }
  public Boolean hasNamespaces() {
    return namespaces != null && !namespaces.isEmpty();
  }
  public A addToResources(int index,String item) {
    if (this.resources == null) {this.resources = new ArrayList<String>();}
    this.resources.add(index, item);
    return (A)this;
  }
  public A setToResources(int index,String item) {
    if (this.resources == null) {this.resources = new ArrayList<String>();}
    this.resources.set(index, item); return (A)this;
  }
  public A addToResources(java.lang.String... items) {
    if (this.resources == null) {this.resources = new ArrayList<String>();}
    for (String item : items) {this.resources.add(item);} return (A)this;
  }
  public A addAllToResources(Collection<String> items) {
    if (this.resources == null) {this.resources = new ArrayList<String>();}
    for (String item : items) {this.resources.add(item);} return (A)this;
  }
  public A removeFromResources(java.lang.String... items) {
    for (String item : items) {if (this.resources!= null){ this.resources.remove(item);}} return (A)this;
  }
  public A removeAllFromResources(Collection<String> items) {
    for (String item : items) {if (this.resources!= null){ this.resources.remove(item);}} return (A)this;
  }
  public List<String> getResources() {
    return this.resources;
  }
  public String getResource(int index) {
    return this.resources.get(index);
  }
  public String getFirstResource() {
    return this.resources.get(0);
  }
  public String getLastResource() {
    return this.resources.get(resources.size() - 1);
  }
  public String getMatchingResource(Predicate<String> predicate) {
    for (String item: resources) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingResource(Predicate<String> predicate) {
    for (String item: resources) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withResources(List<String> resources) {
    if (resources != null) {this.resources = new ArrayList(); for (String item : resources){this.addToResources(item);}} else { this.resources = null;} return (A) this;
  }
  public A withResources(java.lang.String... resources) {
    if (this.resources != null) {this.resources.clear(); _visitables.remove("resources"); }
    if (resources != null) {for (String item :resources){ this.addToResources(item);}} return (A) this;
  }
  public Boolean hasResources() {
    return resources != null && !resources.isEmpty();
  }
  public A addToVerbs(int index,String item) {
    if (this.verbs == null) {this.verbs = new ArrayList<String>();}
    this.verbs.add(index, item);
    return (A)this;
  }
  public A setToVerbs(int index,String item) {
    if (this.verbs == null) {this.verbs = new ArrayList<String>();}
    this.verbs.set(index, item); return (A)this;
  }
  public A addToVerbs(java.lang.String... items) {
    if (this.verbs == null) {this.verbs = new ArrayList<String>();}
    for (String item : items) {this.verbs.add(item);} return (A)this;
  }
  public A addAllToVerbs(Collection<String> items) {
    if (this.verbs == null) {this.verbs = new ArrayList<String>();}
    for (String item : items) {this.verbs.add(item);} return (A)this;
  }
  public A removeFromVerbs(java.lang.String... items) {
    for (String item : items) {if (this.verbs!= null){ this.verbs.remove(item);}} return (A)this;
  }
  public A removeAllFromVerbs(Collection<String> items) {
    for (String item : items) {if (this.verbs!= null){ this.verbs.remove(item);}} return (A)this;
  }
  public List<String> getVerbs() {
    return this.verbs;
  }
  public String getVerb(int index) {
    return this.verbs.get(index);
  }
  public String getFirstVerb() {
    return this.verbs.get(0);
  }
  public String getLastVerb() {
    return this.verbs.get(verbs.size() - 1);
  }
  public String getMatchingVerb(Predicate<String> predicate) {
    for (String item: verbs) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingVerb(Predicate<String> predicate) {
    for (String item: verbs) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withVerbs(List<String> verbs) {
    if (verbs != null) {this.verbs = new ArrayList(); for (String item : verbs){this.addToVerbs(item);}} else { this.verbs = null;} return (A) this;
  }
  public A withVerbs(java.lang.String... verbs) {
    if (this.verbs != null) {this.verbs.clear(); _visitables.remove("verbs"); }
    if (verbs != null) {for (String item :verbs){ this.addToVerbs(item);}} return (A) this;
  }
  public Boolean hasVerbs() {
    return verbs != null && !verbs.isEmpty();
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ResourcePolicyRuleFluentImpl that = (ResourcePolicyRuleFluentImpl) o;
    if (!java.util.Objects.equals(apiGroups, that.apiGroups)) return false;

    if (!java.util.Objects.equals(clusterScope, that.clusterScope)) return false;

    if (!java.util.Objects.equals(namespaces, that.namespaces)) return false;

    if (!java.util.Objects.equals(resources, that.resources)) return false;

    if (!java.util.Objects.equals(verbs, that.verbs)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiGroups,  clusterScope,  namespaces,  resources,  verbs,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiGroups != null && !apiGroups.isEmpty()) { sb.append("apiGroups:"); sb.append(apiGroups + ","); }
    if (clusterScope != null) { sb.append("clusterScope:"); sb.append(clusterScope + ","); }
    if (namespaces != null && !namespaces.isEmpty()) { sb.append("namespaces:"); sb.append(namespaces + ","); }
    if (resources != null && !resources.isEmpty()) { sb.append("resources:"); sb.append(resources + ","); }
    if (verbs != null && !verbs.isEmpty()) { sb.append("verbs:"); sb.append(verbs + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withClusterScope() {
    return withClusterScope(true);
  }
  
}