package io.fabric8.kubernetes.api.model.internal.apiserver.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class StorageVersionConditionBuilder extends StorageVersionConditionFluent<StorageVersionConditionBuilder> implements VisitableBuilder<StorageVersionCondition,StorageVersionConditionBuilder>{
  public StorageVersionConditionBuilder() {
    this(false);
  }
  public StorageVersionConditionBuilder(Boolean validationEnabled) {
    this(new StorageVersionCondition(), validationEnabled);
  }
  public StorageVersionConditionBuilder(StorageVersionConditionFluent<?> fluent) {
    this(fluent, false);
  }
  public StorageVersionConditionBuilder(StorageVersionConditionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new StorageVersionCondition(), validationEnabled);
  }
  public StorageVersionConditionBuilder(StorageVersionConditionFluent<?> fluent,StorageVersionCondition instance) {
    this(fluent, instance, false);
  }
  public StorageVersionConditionBuilder(StorageVersionConditionFluent<?> fluent,StorageVersionCondition instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new StorageVersionCondition());

    if (instance != null) {
      fluent.withLastTransitionTime(instance.getLastTransitionTime());
      fluent.withMessage(instance.getMessage());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withReason(instance.getReason());
      fluent.withStatus(instance.getStatus());
      fluent.withType(instance.getType());
      fluent.withLastTransitionTime(instance.getLastTransitionTime());
      fluent.withMessage(instance.getMessage());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withReason(instance.getReason());
      fluent.withStatus(instance.getStatus());
      fluent.withType(instance.getType());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public StorageVersionConditionBuilder(StorageVersionCondition instance) {
    this(instance,false);
  }
  public StorageVersionConditionBuilder(StorageVersionCondition instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new StorageVersionCondition());

    if (instance != null) {
      this.withLastTransitionTime(instance.getLastTransitionTime());
      this.withMessage(instance.getMessage());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withReason(instance.getReason());
      this.withStatus(instance.getStatus());
      this.withType(instance.getType());
      this.withLastTransitionTime(instance.getLastTransitionTime());
      this.withMessage(instance.getMessage());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withReason(instance.getReason());
      this.withStatus(instance.getStatus());
      this.withType(instance.getType());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  StorageVersionConditionFluent<?> fluent;
  Boolean validationEnabled;
  public StorageVersionCondition build() {
    StorageVersionCondition buildable = new StorageVersionCondition(fluent.getLastTransitionTime(),fluent.getMessage(),fluent.getObservedGeneration(),fluent.getReason(),fluent.getStatus(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}