package io.fabric8.kubernetes.api.model.flowcontrol.v1beta2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class FlowSchemaConditionBuilder extends FlowSchemaConditionFluent<FlowSchemaConditionBuilder> implements VisitableBuilder<FlowSchemaCondition,FlowSchemaConditionBuilder>{
  public FlowSchemaConditionBuilder() {
    this(false);
  }
  public FlowSchemaConditionBuilder(Boolean validationEnabled) {
    this(new FlowSchemaCondition(), validationEnabled);
  }
  public FlowSchemaConditionBuilder(FlowSchemaConditionFluent<?> fluent) {
    this(fluent, false);
  }
  public FlowSchemaConditionBuilder(FlowSchemaConditionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new FlowSchemaCondition(), validationEnabled);
  }
  public FlowSchemaConditionBuilder(FlowSchemaConditionFluent<?> fluent,FlowSchemaCondition instance) {
    this(fluent, instance, false);
  }
  public FlowSchemaConditionBuilder(FlowSchemaConditionFluent<?> fluent,FlowSchemaCondition instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new FlowSchemaCondition());

    if (instance != null) {
      fluent.withLastTransitionTime(instance.getLastTransitionTime());
      fluent.withMessage(instance.getMessage());
      fluent.withReason(instance.getReason());
      fluent.withStatus(instance.getStatus());
      fluent.withType(instance.getType());
      fluent.withLastTransitionTime(instance.getLastTransitionTime());
      fluent.withMessage(instance.getMessage());
      fluent.withReason(instance.getReason());
      fluent.withStatus(instance.getStatus());
      fluent.withType(instance.getType());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public FlowSchemaConditionBuilder(FlowSchemaCondition instance) {
    this(instance,false);
  }
  public FlowSchemaConditionBuilder(FlowSchemaCondition instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new FlowSchemaCondition());

    if (instance != null) {
      this.withLastTransitionTime(instance.getLastTransitionTime());
      this.withMessage(instance.getMessage());
      this.withReason(instance.getReason());
      this.withStatus(instance.getStatus());
      this.withType(instance.getType());
      this.withLastTransitionTime(instance.getLastTransitionTime());
      this.withMessage(instance.getMessage());
      this.withReason(instance.getReason());
      this.withStatus(instance.getStatus());
      this.withType(instance.getType());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  FlowSchemaConditionFluent<?> fluent;
  Boolean validationEnabled;
  public FlowSchemaCondition build() {
    FlowSchemaCondition buildable = new FlowSchemaCondition(fluent.getLastTransitionTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}