package io.fabric8.kubernetes.api.model.flowcontrol.v1beta2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class LimitResponseBuilder extends LimitResponseFluent<LimitResponseBuilder> implements VisitableBuilder<LimitResponse,LimitResponseBuilder>{
  public LimitResponseBuilder() {
    this(false);
  }
  public LimitResponseBuilder(Boolean validationEnabled) {
    this(new LimitResponse(), validationEnabled);
  }
  public LimitResponseBuilder(LimitResponseFluent<?> fluent) {
    this(fluent, false);
  }
  public LimitResponseBuilder(LimitResponseFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new LimitResponse(), validationEnabled);
  }
  public LimitResponseBuilder(LimitResponseFluent<?> fluent,LimitResponse instance) {
    this(fluent, instance, false);
  }
  public LimitResponseBuilder(LimitResponseFluent<?> fluent,LimitResponse instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new LimitResponse());

    if (instance != null) {
      fluent.withQueuing(instance.getQueuing());
      fluent.withType(instance.getType());
      fluent.withQueuing(instance.getQueuing());
      fluent.withType(instance.getType());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public LimitResponseBuilder(LimitResponse instance) {
    this(instance,false);
  }
  public LimitResponseBuilder(LimitResponse instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new LimitResponse());

    if (instance != null) {
      this.withQueuing(instance.getQueuing());
      this.withType(instance.getType());
      this.withQueuing(instance.getQueuing());
      this.withType(instance.getType());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  LimitResponseFluent<?> fluent;
  Boolean validationEnabled;
  public LimitResponse build() {
    LimitResponse buildable = new LimitResponse(fluent.buildQueuing(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}