package io.fabric8.kubernetes.api.model.gatewayapi.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class HTTPRouteRuleFluent<A extends HTTPRouteRuleFluent<A>> extends BaseFluent<A>{
  public HTTPRouteRuleFluent() {
  }
  
  public HTTPRouteRuleFluent(HTTPRouteRule instance) {
    this.copyInstance(instance);
  }
  private ArrayList<HTTPBackendRefBuilder> backendRefs = new ArrayList<HTTPBackendRefBuilder>();
  private ArrayList<HTTPRouteFilterBuilder> filters = new ArrayList<HTTPRouteFilterBuilder>();
  private ArrayList<HTTPRouteMatchBuilder> matches = new ArrayList<HTTPRouteMatchBuilder>();
  private HTTPRouteTimeoutsBuilder timeouts;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(HTTPRouteRule instance) {
    instance = (instance != null ? instance : new HTTPRouteRule());
    if (instance != null) {
          this.withBackendRefs(instance.getBackendRefs());
          this.withFilters(instance.getFilters());
          this.withMatches(instance.getMatches());
          this.withTimeouts(instance.getTimeouts());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToBackendRefs(int index,HTTPBackendRef item) {
    if (this.backendRefs == null) {this.backendRefs = new ArrayList<HTTPBackendRefBuilder>();}
    HTTPBackendRefBuilder builder = new HTTPBackendRefBuilder(item);
    if (index < 0 || index >= backendRefs.size()) { _visitables.get("backendRefs").add(builder); backendRefs.add(builder); } else { _visitables.get("backendRefs").add(index, builder); backendRefs.add(index, builder);}
    return (A)this;
  }
  
  public A setToBackendRefs(int index,HTTPBackendRef item) {
    if (this.backendRefs == null) {this.backendRefs = new ArrayList<HTTPBackendRefBuilder>();}
    HTTPBackendRefBuilder builder = new HTTPBackendRefBuilder(item);
    if (index < 0 || index >= backendRefs.size()) { _visitables.get("backendRefs").add(builder); backendRefs.add(builder); } else { _visitables.get("backendRefs").set(index, builder); backendRefs.set(index, builder);}
    return (A)this;
  }
  
  public A addToBackendRefs(io.fabric8.kubernetes.api.model.gatewayapi.v1.HTTPBackendRef... items) {
    if (this.backendRefs == null) {this.backendRefs = new ArrayList<HTTPBackendRefBuilder>();}
    for (HTTPBackendRef item : items) {HTTPBackendRefBuilder builder = new HTTPBackendRefBuilder(item);_visitables.get("backendRefs").add(builder);this.backendRefs.add(builder);} return (A)this;
  }
  
  public A addAllToBackendRefs(Collection<HTTPBackendRef> items) {
    if (this.backendRefs == null) {this.backendRefs = new ArrayList<HTTPBackendRefBuilder>();}
    for (HTTPBackendRef item : items) {HTTPBackendRefBuilder builder = new HTTPBackendRefBuilder(item);_visitables.get("backendRefs").add(builder);this.backendRefs.add(builder);} return (A)this;
  }
  
  public A removeFromBackendRefs(io.fabric8.kubernetes.api.model.gatewayapi.v1.HTTPBackendRef... items) {
    if (this.backendRefs == null) return (A)this;
    for (HTTPBackendRef item : items) {HTTPBackendRefBuilder builder = new HTTPBackendRefBuilder(item);_visitables.get("backendRefs").remove(builder); this.backendRefs.remove(builder);} return (A)this;
  }
  
  public A removeAllFromBackendRefs(Collection<HTTPBackendRef> items) {
    if (this.backendRefs == null) return (A)this;
    for (HTTPBackendRef item : items) {HTTPBackendRefBuilder builder = new HTTPBackendRefBuilder(item);_visitables.get("backendRefs").remove(builder); this.backendRefs.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromBackendRefs(Predicate<HTTPBackendRefBuilder> predicate) {
    if (backendRefs == null) return (A) this;
    final Iterator<HTTPBackendRefBuilder> each = backendRefs.iterator();
    final List visitables = _visitables.get("backendRefs");
    while (each.hasNext()) {
      HTTPBackendRefBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<HTTPBackendRef> buildBackendRefs() {
    return this.backendRefs != null ? build(backendRefs) : null;
  }
  
  public HTTPBackendRef buildBackendRef(int index) {
    return this.backendRefs.get(index).build();
  }
  
  public HTTPBackendRef buildFirstBackendRef() {
    return this.backendRefs.get(0).build();
  }
  
  public HTTPBackendRef buildLastBackendRef() {
    return this.backendRefs.get(backendRefs.size() - 1).build();
  }
  
  public HTTPBackendRef buildMatchingBackendRef(Predicate<HTTPBackendRefBuilder> predicate) {
      for (HTTPBackendRefBuilder item : backendRefs) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingBackendRef(Predicate<HTTPBackendRefBuilder> predicate) {
      for (HTTPBackendRefBuilder item : backendRefs) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withBackendRefs(List<HTTPBackendRef> backendRefs) {
    if (this.backendRefs != null) {
      this._visitables.get("backendRefs").clear();
    }
    if (backendRefs != null) {
        this.backendRefs = new ArrayList();
        for (HTTPBackendRef item : backendRefs) {
          this.addToBackendRefs(item);
        }
    } else {
      this.backendRefs = null;
    }
    return (A) this;
  }
  
  public A withBackendRefs(io.fabric8.kubernetes.api.model.gatewayapi.v1.HTTPBackendRef... backendRefs) {
    if (this.backendRefs != null) {
        this.backendRefs.clear();
        _visitables.remove("backendRefs");
    }
    if (backendRefs != null) {
      for (HTTPBackendRef item : backendRefs) {
        this.addToBackendRefs(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasBackendRefs() {
    return this.backendRefs != null && !this.backendRefs.isEmpty();
  }
  
  public BackendRefsNested<A> addNewBackendRef() {
    return new BackendRefsNested(-1, null);
  }
  
  public BackendRefsNested<A> addNewBackendRefLike(HTTPBackendRef item) {
    return new BackendRefsNested(-1, item);
  }
  
  public BackendRefsNested<A> setNewBackendRefLike(int index,HTTPBackendRef item) {
    return new BackendRefsNested(index, item);
  }
  
  public BackendRefsNested<A> editBackendRef(int index) {
    if (backendRefs.size() <= index) throw new RuntimeException("Can't edit backendRefs. Index exceeds size.");
    return setNewBackendRefLike(index, buildBackendRef(index));
  }
  
  public BackendRefsNested<A> editFirstBackendRef() {
    if (backendRefs.size() == 0) throw new RuntimeException("Can't edit first backendRefs. The list is empty.");
    return setNewBackendRefLike(0, buildBackendRef(0));
  }
  
  public BackendRefsNested<A> editLastBackendRef() {
    int index = backendRefs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last backendRefs. The list is empty.");
    return setNewBackendRefLike(index, buildBackendRef(index));
  }
  
  public BackendRefsNested<A> editMatchingBackendRef(Predicate<HTTPBackendRefBuilder> predicate) {
    int index = -1;
    for (int i=0;i<backendRefs.size();i++) { 
    if (predicate.test(backendRefs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching backendRefs. No match found.");
    return setNewBackendRefLike(index, buildBackendRef(index));
  }
  
  public A addToFilters(int index,HTTPRouteFilter item) {
    if (this.filters == null) {this.filters = new ArrayList<HTTPRouteFilterBuilder>();}
    HTTPRouteFilterBuilder builder = new HTTPRouteFilterBuilder(item);
    if (index < 0 || index >= filters.size()) { _visitables.get("filters").add(builder); filters.add(builder); } else { _visitables.get("filters").add(index, builder); filters.add(index, builder);}
    return (A)this;
  }
  
  public A setToFilters(int index,HTTPRouteFilter item) {
    if (this.filters == null) {this.filters = new ArrayList<HTTPRouteFilterBuilder>();}
    HTTPRouteFilterBuilder builder = new HTTPRouteFilterBuilder(item);
    if (index < 0 || index >= filters.size()) { _visitables.get("filters").add(builder); filters.add(builder); } else { _visitables.get("filters").set(index, builder); filters.set(index, builder);}
    return (A)this;
  }
  
  public A addToFilters(io.fabric8.kubernetes.api.model.gatewayapi.v1.HTTPRouteFilter... items) {
    if (this.filters == null) {this.filters = new ArrayList<HTTPRouteFilterBuilder>();}
    for (HTTPRouteFilter item : items) {HTTPRouteFilterBuilder builder = new HTTPRouteFilterBuilder(item);_visitables.get("filters").add(builder);this.filters.add(builder);} return (A)this;
  }
  
  public A addAllToFilters(Collection<HTTPRouteFilter> items) {
    if (this.filters == null) {this.filters = new ArrayList<HTTPRouteFilterBuilder>();}
    for (HTTPRouteFilter item : items) {HTTPRouteFilterBuilder builder = new HTTPRouteFilterBuilder(item);_visitables.get("filters").add(builder);this.filters.add(builder);} return (A)this;
  }
  
  public A removeFromFilters(io.fabric8.kubernetes.api.model.gatewayapi.v1.HTTPRouteFilter... items) {
    if (this.filters == null) return (A)this;
    for (HTTPRouteFilter item : items) {HTTPRouteFilterBuilder builder = new HTTPRouteFilterBuilder(item);_visitables.get("filters").remove(builder); this.filters.remove(builder);} return (A)this;
  }
  
  public A removeAllFromFilters(Collection<HTTPRouteFilter> items) {
    if (this.filters == null) return (A)this;
    for (HTTPRouteFilter item : items) {HTTPRouteFilterBuilder builder = new HTTPRouteFilterBuilder(item);_visitables.get("filters").remove(builder); this.filters.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromFilters(Predicate<HTTPRouteFilterBuilder> predicate) {
    if (filters == null) return (A) this;
    final Iterator<HTTPRouteFilterBuilder> each = filters.iterator();
    final List visitables = _visitables.get("filters");
    while (each.hasNext()) {
      HTTPRouteFilterBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<HTTPRouteFilter> buildFilters() {
    return this.filters != null ? build(filters) : null;
  }
  
  public HTTPRouteFilter buildFilter(int index) {
    return this.filters.get(index).build();
  }
  
  public HTTPRouteFilter buildFirstFilter() {
    return this.filters.get(0).build();
  }
  
  public HTTPRouteFilter buildLastFilter() {
    return this.filters.get(filters.size() - 1).build();
  }
  
  public HTTPRouteFilter buildMatchingFilter(Predicate<HTTPRouteFilterBuilder> predicate) {
      for (HTTPRouteFilterBuilder item : filters) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingFilter(Predicate<HTTPRouteFilterBuilder> predicate) {
      for (HTTPRouteFilterBuilder item : filters) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withFilters(List<HTTPRouteFilter> filters) {
    if (this.filters != null) {
      this._visitables.get("filters").clear();
    }
    if (filters != null) {
        this.filters = new ArrayList();
        for (HTTPRouteFilter item : filters) {
          this.addToFilters(item);
        }
    } else {
      this.filters = null;
    }
    return (A) this;
  }
  
  public A withFilters(io.fabric8.kubernetes.api.model.gatewayapi.v1.HTTPRouteFilter... filters) {
    if (this.filters != null) {
        this.filters.clear();
        _visitables.remove("filters");
    }
    if (filters != null) {
      for (HTTPRouteFilter item : filters) {
        this.addToFilters(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasFilters() {
    return this.filters != null && !this.filters.isEmpty();
  }
  
  public FiltersNested<A> addNewFilter() {
    return new FiltersNested(-1, null);
  }
  
  public FiltersNested<A> addNewFilterLike(HTTPRouteFilter item) {
    return new FiltersNested(-1, item);
  }
  
  public FiltersNested<A> setNewFilterLike(int index,HTTPRouteFilter item) {
    return new FiltersNested(index, item);
  }
  
  public FiltersNested<A> editFilter(int index) {
    if (filters.size() <= index) throw new RuntimeException("Can't edit filters. Index exceeds size.");
    return setNewFilterLike(index, buildFilter(index));
  }
  
  public FiltersNested<A> editFirstFilter() {
    if (filters.size() == 0) throw new RuntimeException("Can't edit first filters. The list is empty.");
    return setNewFilterLike(0, buildFilter(0));
  }
  
  public FiltersNested<A> editLastFilter() {
    int index = filters.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last filters. The list is empty.");
    return setNewFilterLike(index, buildFilter(index));
  }
  
  public FiltersNested<A> editMatchingFilter(Predicate<HTTPRouteFilterBuilder> predicate) {
    int index = -1;
    for (int i=0;i<filters.size();i++) { 
    if (predicate.test(filters.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching filters. No match found.");
    return setNewFilterLike(index, buildFilter(index));
  }
  
  public A addToMatches(int index,HTTPRouteMatch item) {
    if (this.matches == null) {this.matches = new ArrayList<HTTPRouteMatchBuilder>();}
    HTTPRouteMatchBuilder builder = new HTTPRouteMatchBuilder(item);
    if (index < 0 || index >= matches.size()) { _visitables.get("matches").add(builder); matches.add(builder); } else { _visitables.get("matches").add(index, builder); matches.add(index, builder);}
    return (A)this;
  }
  
  public A setToMatches(int index,HTTPRouteMatch item) {
    if (this.matches == null) {this.matches = new ArrayList<HTTPRouteMatchBuilder>();}
    HTTPRouteMatchBuilder builder = new HTTPRouteMatchBuilder(item);
    if (index < 0 || index >= matches.size()) { _visitables.get("matches").add(builder); matches.add(builder); } else { _visitables.get("matches").set(index, builder); matches.set(index, builder);}
    return (A)this;
  }
  
  public A addToMatches(io.fabric8.kubernetes.api.model.gatewayapi.v1.HTTPRouteMatch... items) {
    if (this.matches == null) {this.matches = new ArrayList<HTTPRouteMatchBuilder>();}
    for (HTTPRouteMatch item : items) {HTTPRouteMatchBuilder builder = new HTTPRouteMatchBuilder(item);_visitables.get("matches").add(builder);this.matches.add(builder);} return (A)this;
  }
  
  public A addAllToMatches(Collection<HTTPRouteMatch> items) {
    if (this.matches == null) {this.matches = new ArrayList<HTTPRouteMatchBuilder>();}
    for (HTTPRouteMatch item : items) {HTTPRouteMatchBuilder builder = new HTTPRouteMatchBuilder(item);_visitables.get("matches").add(builder);this.matches.add(builder);} return (A)this;
  }
  
  public A removeFromMatches(io.fabric8.kubernetes.api.model.gatewayapi.v1.HTTPRouteMatch... items) {
    if (this.matches == null) return (A)this;
    for (HTTPRouteMatch item : items) {HTTPRouteMatchBuilder builder = new HTTPRouteMatchBuilder(item);_visitables.get("matches").remove(builder); this.matches.remove(builder);} return (A)this;
  }
  
  public A removeAllFromMatches(Collection<HTTPRouteMatch> items) {
    if (this.matches == null) return (A)this;
    for (HTTPRouteMatch item : items) {HTTPRouteMatchBuilder builder = new HTTPRouteMatchBuilder(item);_visitables.get("matches").remove(builder); this.matches.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromMatches(Predicate<HTTPRouteMatchBuilder> predicate) {
    if (matches == null) return (A) this;
    final Iterator<HTTPRouteMatchBuilder> each = matches.iterator();
    final List visitables = _visitables.get("matches");
    while (each.hasNext()) {
      HTTPRouteMatchBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<HTTPRouteMatch> buildMatches() {
    return this.matches != null ? build(matches) : null;
  }
  
  public HTTPRouteMatch buildMatch(int index) {
    return this.matches.get(index).build();
  }
  
  public HTTPRouteMatch buildFirstMatch() {
    return this.matches.get(0).build();
  }
  
  public HTTPRouteMatch buildLastMatch() {
    return this.matches.get(matches.size() - 1).build();
  }
  
  public HTTPRouteMatch buildMatchingMatch(Predicate<HTTPRouteMatchBuilder> predicate) {
      for (HTTPRouteMatchBuilder item : matches) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingMatch(Predicate<HTTPRouteMatchBuilder> predicate) {
      for (HTTPRouteMatchBuilder item : matches) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withMatches(List<HTTPRouteMatch> matches) {
    if (this.matches != null) {
      this._visitables.get("matches").clear();
    }
    if (matches != null) {
        this.matches = new ArrayList();
        for (HTTPRouteMatch item : matches) {
          this.addToMatches(item);
        }
    } else {
      this.matches = null;
    }
    return (A) this;
  }
  
  public A withMatches(io.fabric8.kubernetes.api.model.gatewayapi.v1.HTTPRouteMatch... matches) {
    if (this.matches != null) {
        this.matches.clear();
        _visitables.remove("matches");
    }
    if (matches != null) {
      for (HTTPRouteMatch item : matches) {
        this.addToMatches(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasMatches() {
    return this.matches != null && !this.matches.isEmpty();
  }
  
  public MatchesNested<A> addNewMatch() {
    return new MatchesNested(-1, null);
  }
  
  public MatchesNested<A> addNewMatchLike(HTTPRouteMatch item) {
    return new MatchesNested(-1, item);
  }
  
  public MatchesNested<A> setNewMatchLike(int index,HTTPRouteMatch item) {
    return new MatchesNested(index, item);
  }
  
  public MatchesNested<A> editMatch(int index) {
    if (matches.size() <= index) throw new RuntimeException("Can't edit matches. Index exceeds size.");
    return setNewMatchLike(index, buildMatch(index));
  }
  
  public MatchesNested<A> editFirstMatch() {
    if (matches.size() == 0) throw new RuntimeException("Can't edit first matches. The list is empty.");
    return setNewMatchLike(0, buildMatch(0));
  }
  
  public MatchesNested<A> editLastMatch() {
    int index = matches.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last matches. The list is empty.");
    return setNewMatchLike(index, buildMatch(index));
  }
  
  public MatchesNested<A> editMatchingMatch(Predicate<HTTPRouteMatchBuilder> predicate) {
    int index = -1;
    for (int i=0;i<matches.size();i++) { 
    if (predicate.test(matches.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching matches. No match found.");
    return setNewMatchLike(index, buildMatch(index));
  }
  
  public HTTPRouteTimeouts buildTimeouts() {
    return this.timeouts != null ? this.timeouts.build() : null;
  }
  
  public A withTimeouts(HTTPRouteTimeouts timeouts) {
    this._visitables.remove("timeouts");
    if (timeouts != null) {
        this.timeouts = new HTTPRouteTimeoutsBuilder(timeouts);
        this._visitables.get("timeouts").add(this.timeouts);
    } else {
        this.timeouts = null;
        this._visitables.get("timeouts").remove(this.timeouts);
    }
    return (A) this;
  }
  
  public boolean hasTimeouts() {
    return this.timeouts != null;
  }
  
  public A withNewTimeouts(String backendRequest,String request) {
    return (A)withTimeouts(new HTTPRouteTimeouts(backendRequest, request));
  }
  
  public TimeoutsNested<A> withNewTimeouts() {
    return new TimeoutsNested(null);
  }
  
  public TimeoutsNested<A> withNewTimeoutsLike(HTTPRouteTimeouts item) {
    return new TimeoutsNested(item);
  }
  
  public TimeoutsNested<A> editTimeouts() {
    return withNewTimeoutsLike(java.util.Optional.ofNullable(buildTimeouts()).orElse(null));
  }
  
  public TimeoutsNested<A> editOrNewTimeouts() {
    return withNewTimeoutsLike(java.util.Optional.ofNullable(buildTimeouts()).orElse(new HTTPRouteTimeoutsBuilder().build()));
  }
  
  public TimeoutsNested<A> editOrNewTimeoutsLike(HTTPRouteTimeouts item) {
    return withNewTimeoutsLike(java.util.Optional.ofNullable(buildTimeouts()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    HTTPRouteRuleFluent that = (HTTPRouteRuleFluent) o;
    if (!java.util.Objects.equals(backendRefs, that.backendRefs)) return false;
    if (!java.util.Objects.equals(filters, that.filters)) return false;
    if (!java.util.Objects.equals(matches, that.matches)) return false;
    if (!java.util.Objects.equals(timeouts, that.timeouts)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(backendRefs,  filters,  matches,  timeouts,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (backendRefs != null && !backendRefs.isEmpty()) { sb.append("backendRefs:"); sb.append(backendRefs + ","); }
    if (filters != null && !filters.isEmpty()) { sb.append("filters:"); sb.append(filters + ","); }
    if (matches != null && !matches.isEmpty()) { sb.append("matches:"); sb.append(matches + ","); }
    if (timeouts != null) { sb.append("timeouts:"); sb.append(timeouts + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class BackendRefsNested<N> extends HTTPBackendRefFluent<BackendRefsNested<N>> implements Nested<N>{
    BackendRefsNested(int index,HTTPBackendRef item) {
      this.index = index;
      this.builder = new HTTPBackendRefBuilder(this, item);
    }
    HTTPBackendRefBuilder builder;
    int index;
    
    public N and() {
      return (N) HTTPRouteRuleFluent.this.setToBackendRefs(index,builder.build());
    }
    
    public N endBackendRef() {
      return and();
    }
    
  
  }
  public class FiltersNested<N> extends HTTPRouteFilterFluent<FiltersNested<N>> implements Nested<N>{
    FiltersNested(int index,HTTPRouteFilter item) {
      this.index = index;
      this.builder = new HTTPRouteFilterBuilder(this, item);
    }
    HTTPRouteFilterBuilder builder;
    int index;
    
    public N and() {
      return (N) HTTPRouteRuleFluent.this.setToFilters(index,builder.build());
    }
    
    public N endFilter() {
      return and();
    }
    
  
  }
  public class MatchesNested<N> extends HTTPRouteMatchFluent<MatchesNested<N>> implements Nested<N>{
    MatchesNested(int index,HTTPRouteMatch item) {
      this.index = index;
      this.builder = new HTTPRouteMatchBuilder(this, item);
    }
    HTTPRouteMatchBuilder builder;
    int index;
    
    public N and() {
      return (N) HTTPRouteRuleFluent.this.setToMatches(index,builder.build());
    }
    
    public N endMatch() {
      return and();
    }
    
  
  }
  public class TimeoutsNested<N> extends HTTPRouteTimeoutsFluent<TimeoutsNested<N>> implements Nested<N>{
    TimeoutsNested(HTTPRouteTimeouts item) {
      this.builder = new HTTPRouteTimeoutsBuilder(this, item);
    }
    HTTPRouteTimeoutsBuilder builder;
    
    public N and() {
      return (N) HTTPRouteRuleFluent.this.withTimeouts(builder.build());
    }
    
    public N endTimeouts() {
      return and();
    }
    
  
  }

}