package io.fabric8.kubernetes.api.model.gatewayapi.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ReferenceGrantSpecFluent<A extends ReferenceGrantSpecFluent<A>> extends BaseFluent<A>{
  public ReferenceGrantSpecFluent() {
  }
  
  public ReferenceGrantSpecFluent(ReferenceGrantSpec instance) {
    this.copyInstance(instance);
  }
  private ArrayList<ReferenceGrantFromBuilder> from = new ArrayList<ReferenceGrantFromBuilder>();
  private ArrayList<ReferenceGrantToBuilder> to = new ArrayList<ReferenceGrantToBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ReferenceGrantSpec instance) {
    instance = (instance != null ? instance : new ReferenceGrantSpec());
    if (instance != null) {
          this.withFrom(instance.getFrom());
          this.withTo(instance.getTo());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToFrom(int index,ReferenceGrantFrom item) {
    if (this.from == null) {this.from = new ArrayList<ReferenceGrantFromBuilder>();}
    ReferenceGrantFromBuilder builder = new ReferenceGrantFromBuilder(item);
    if (index < 0 || index >= from.size()) { _visitables.get("from").add(builder); from.add(builder); } else { _visitables.get("from").add(index, builder); from.add(index, builder);}
    return (A)this;
  }
  
  public A setToFrom(int index,ReferenceGrantFrom item) {
    if (this.from == null) {this.from = new ArrayList<ReferenceGrantFromBuilder>();}
    ReferenceGrantFromBuilder builder = new ReferenceGrantFromBuilder(item);
    if (index < 0 || index >= from.size()) { _visitables.get("from").add(builder); from.add(builder); } else { _visitables.get("from").set(index, builder); from.set(index, builder);}
    return (A)this;
  }
  
  public A addToFrom(io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.ReferenceGrantFrom... items) {
    if (this.from == null) {this.from = new ArrayList<ReferenceGrantFromBuilder>();}
    for (ReferenceGrantFrom item : items) {ReferenceGrantFromBuilder builder = new ReferenceGrantFromBuilder(item);_visitables.get("from").add(builder);this.from.add(builder);} return (A)this;
  }
  
  public A addAllToFrom(Collection<ReferenceGrantFrom> items) {
    if (this.from == null) {this.from = new ArrayList<ReferenceGrantFromBuilder>();}
    for (ReferenceGrantFrom item : items) {ReferenceGrantFromBuilder builder = new ReferenceGrantFromBuilder(item);_visitables.get("from").add(builder);this.from.add(builder);} return (A)this;
  }
  
  public A removeFromFrom(io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.ReferenceGrantFrom... items) {
    if (this.from == null) return (A)this;
    for (ReferenceGrantFrom item : items) {ReferenceGrantFromBuilder builder = new ReferenceGrantFromBuilder(item);_visitables.get("from").remove(builder); this.from.remove(builder);} return (A)this;
  }
  
  public A removeAllFromFrom(Collection<ReferenceGrantFrom> items) {
    if (this.from == null) return (A)this;
    for (ReferenceGrantFrom item : items) {ReferenceGrantFromBuilder builder = new ReferenceGrantFromBuilder(item);_visitables.get("from").remove(builder); this.from.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromFrom(Predicate<ReferenceGrantFromBuilder> predicate) {
    if (from == null) return (A) this;
    final Iterator<ReferenceGrantFromBuilder> each = from.iterator();
    final List visitables = _visitables.get("from");
    while (each.hasNext()) {
      ReferenceGrantFromBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<ReferenceGrantFrom> buildFrom() {
    return this.from != null ? build(from) : null;
  }
  
  public ReferenceGrantFrom buildFrom(int index) {
    return this.from.get(index).build();
  }
  
  public ReferenceGrantFrom buildFirstFrom() {
    return this.from.get(0).build();
  }
  
  public ReferenceGrantFrom buildLastFrom() {
    return this.from.get(from.size() - 1).build();
  }
  
  public ReferenceGrantFrom buildMatchingFrom(Predicate<ReferenceGrantFromBuilder> predicate) {
      for (ReferenceGrantFromBuilder item : from) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingFrom(Predicate<ReferenceGrantFromBuilder> predicate) {
      for (ReferenceGrantFromBuilder item : from) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withFrom(List<ReferenceGrantFrom> from) {
    if (this.from != null) {
      this._visitables.get("from").clear();
    }
    if (from != null) {
        this.from = new ArrayList();
        for (ReferenceGrantFrom item : from) {
          this.addToFrom(item);
        }
    } else {
      this.from = null;
    }
    return (A) this;
  }
  
  public A withFrom(io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.ReferenceGrantFrom... from) {
    if (this.from != null) {
        this.from.clear();
        _visitables.remove("from");
    }
    if (from != null) {
      for (ReferenceGrantFrom item : from) {
        this.addToFrom(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasFrom() {
    return this.from != null && !this.from.isEmpty();
  }
  
  public A addNewFrom(String group,String kind,String namespace) {
    return (A)addToFrom(new ReferenceGrantFrom(group, kind, namespace));
  }
  
  public FromNested<A> addNewFrom() {
    return new FromNested(-1, null);
  }
  
  public FromNested<A> addNewFromLike(ReferenceGrantFrom item) {
    return new FromNested(-1, item);
  }
  
  public FromNested<A> setNewFromLike(int index,ReferenceGrantFrom item) {
    return new FromNested(index, item);
  }
  
  public FromNested<A> editFrom(int index) {
    if (from.size() <= index) throw new RuntimeException("Can't edit from. Index exceeds size.");
    return setNewFromLike(index, buildFrom(index));
  }
  
  public FromNested<A> editFirstFrom() {
    if (from.size() == 0) throw new RuntimeException("Can't edit first from. The list is empty.");
    return setNewFromLike(0, buildFrom(0));
  }
  
  public FromNested<A> editLastFrom() {
    int index = from.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last from. The list is empty.");
    return setNewFromLike(index, buildFrom(index));
  }
  
  public FromNested<A> editMatchingFrom(Predicate<ReferenceGrantFromBuilder> predicate) {
    int index = -1;
    for (int i=0;i<from.size();i++) { 
    if (predicate.test(from.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching from. No match found.");
    return setNewFromLike(index, buildFrom(index));
  }
  
  public A addToTo(int index,ReferenceGrantTo item) {
    if (this.to == null) {this.to = new ArrayList<ReferenceGrantToBuilder>();}
    ReferenceGrantToBuilder builder = new ReferenceGrantToBuilder(item);
    if (index < 0 || index >= to.size()) { _visitables.get("to").add(builder); to.add(builder); } else { _visitables.get("to").add(index, builder); to.add(index, builder);}
    return (A)this;
  }
  
  public A setToTo(int index,ReferenceGrantTo item) {
    if (this.to == null) {this.to = new ArrayList<ReferenceGrantToBuilder>();}
    ReferenceGrantToBuilder builder = new ReferenceGrantToBuilder(item);
    if (index < 0 || index >= to.size()) { _visitables.get("to").add(builder); to.add(builder); } else { _visitables.get("to").set(index, builder); to.set(index, builder);}
    return (A)this;
  }
  
  public A addToTo(io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.ReferenceGrantTo... items) {
    if (this.to == null) {this.to = new ArrayList<ReferenceGrantToBuilder>();}
    for (ReferenceGrantTo item : items) {ReferenceGrantToBuilder builder = new ReferenceGrantToBuilder(item);_visitables.get("to").add(builder);this.to.add(builder);} return (A)this;
  }
  
  public A addAllToTo(Collection<ReferenceGrantTo> items) {
    if (this.to == null) {this.to = new ArrayList<ReferenceGrantToBuilder>();}
    for (ReferenceGrantTo item : items) {ReferenceGrantToBuilder builder = new ReferenceGrantToBuilder(item);_visitables.get("to").add(builder);this.to.add(builder);} return (A)this;
  }
  
  public A removeFromTo(io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.ReferenceGrantTo... items) {
    if (this.to == null) return (A)this;
    for (ReferenceGrantTo item : items) {ReferenceGrantToBuilder builder = new ReferenceGrantToBuilder(item);_visitables.get("to").remove(builder); this.to.remove(builder);} return (A)this;
  }
  
  public A removeAllFromTo(Collection<ReferenceGrantTo> items) {
    if (this.to == null) return (A)this;
    for (ReferenceGrantTo item : items) {ReferenceGrantToBuilder builder = new ReferenceGrantToBuilder(item);_visitables.get("to").remove(builder); this.to.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromTo(Predicate<ReferenceGrantToBuilder> predicate) {
    if (to == null) return (A) this;
    final Iterator<ReferenceGrantToBuilder> each = to.iterator();
    final List visitables = _visitables.get("to");
    while (each.hasNext()) {
      ReferenceGrantToBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<ReferenceGrantTo> buildTo() {
    return this.to != null ? build(to) : null;
  }
  
  public ReferenceGrantTo buildTo(int index) {
    return this.to.get(index).build();
  }
  
  public ReferenceGrantTo buildFirstTo() {
    return this.to.get(0).build();
  }
  
  public ReferenceGrantTo buildLastTo() {
    return this.to.get(to.size() - 1).build();
  }
  
  public ReferenceGrantTo buildMatchingTo(Predicate<ReferenceGrantToBuilder> predicate) {
      for (ReferenceGrantToBuilder item : to) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingTo(Predicate<ReferenceGrantToBuilder> predicate) {
      for (ReferenceGrantToBuilder item : to) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withTo(List<ReferenceGrantTo> to) {
    if (this.to != null) {
      this._visitables.get("to").clear();
    }
    if (to != null) {
        this.to = new ArrayList();
        for (ReferenceGrantTo item : to) {
          this.addToTo(item);
        }
    } else {
      this.to = null;
    }
    return (A) this;
  }
  
  public A withTo(io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.ReferenceGrantTo... to) {
    if (this.to != null) {
        this.to.clear();
        _visitables.remove("to");
    }
    if (to != null) {
      for (ReferenceGrantTo item : to) {
        this.addToTo(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasTo() {
    return this.to != null && !this.to.isEmpty();
  }
  
  public A addNewTo(String group,String kind,String name) {
    return (A)addToTo(new ReferenceGrantTo(group, kind, name));
  }
  
  public ToNested<A> addNewTo() {
    return new ToNested(-1, null);
  }
  
  public ToNested<A> addNewToLike(ReferenceGrantTo item) {
    return new ToNested(-1, item);
  }
  
  public ToNested<A> setNewToLike(int index,ReferenceGrantTo item) {
    return new ToNested(index, item);
  }
  
  public ToNested<A> editTo(int index) {
    if (to.size() <= index) throw new RuntimeException("Can't edit to. Index exceeds size.");
    return setNewToLike(index, buildTo(index));
  }
  
  public ToNested<A> editFirstTo() {
    if (to.size() == 0) throw new RuntimeException("Can't edit first to. The list is empty.");
    return setNewToLike(0, buildTo(0));
  }
  
  public ToNested<A> editLastTo() {
    int index = to.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last to. The list is empty.");
    return setNewToLike(index, buildTo(index));
  }
  
  public ToNested<A> editMatchingTo(Predicate<ReferenceGrantToBuilder> predicate) {
    int index = -1;
    for (int i=0;i<to.size();i++) { 
    if (predicate.test(to.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching to. No match found.");
    return setNewToLike(index, buildTo(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ReferenceGrantSpecFluent that = (ReferenceGrantSpecFluent) o;
    if (!java.util.Objects.equals(from, that.from)) return false;
    if (!java.util.Objects.equals(to, that.to)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(from,  to,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (from != null && !from.isEmpty()) { sb.append("from:"); sb.append(from + ","); }
    if (to != null && !to.isEmpty()) { sb.append("to:"); sb.append(to + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class FromNested<N> extends ReferenceGrantFromFluent<FromNested<N>> implements Nested<N>{
    FromNested(int index,ReferenceGrantFrom item) {
      this.index = index;
      this.builder = new ReferenceGrantFromBuilder(this, item);
    }
    ReferenceGrantFromBuilder builder;
    int index;
    
    public N and() {
      return (N) ReferenceGrantSpecFluent.this.setToFrom(index,builder.build());
    }
    
    public N endFrom() {
      return and();
    }
    
  
  }
  public class ToNested<N> extends ReferenceGrantToFluent<ToNested<N>> implements Nested<N>{
    ToNested(int index,ReferenceGrantTo item) {
      this.index = index;
      this.builder = new ReferenceGrantToBuilder(this, item);
    }
    ReferenceGrantToBuilder builder;
    int index;
    
    public N and() {
      return (N) ReferenceGrantSpecFluent.this.setToTo(index,builder.build());
    }
    
    public N endTo() {
      return and();
    }
    
  
  }

}