package io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HTTPRequestRedirectFilterBuilder extends HTTPRequestRedirectFilterFluentImpl<HTTPRequestRedirectFilterBuilder> implements VisitableBuilder<HTTPRequestRedirectFilter,HTTPRequestRedirectFilterBuilder>{
  public HTTPRequestRedirectFilterBuilder() {
    this(false);
  }
  public HTTPRequestRedirectFilterBuilder(Boolean validationEnabled) {
    this(new HTTPRequestRedirectFilter(), validationEnabled);
  }
  public HTTPRequestRedirectFilterBuilder(HTTPRequestRedirectFilterFluent<?> fluent) {
    this(fluent, false);
  }
  public HTTPRequestRedirectFilterBuilder(HTTPRequestRedirectFilterFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HTTPRequestRedirectFilter(), validationEnabled);
  }
  public HTTPRequestRedirectFilterBuilder(HTTPRequestRedirectFilterFluent<?> fluent,HTTPRequestRedirectFilter instance) {
    this(fluent, instance, false);
  }
  public HTTPRequestRedirectFilterBuilder(HTTPRequestRedirectFilterFluent<?> fluent,HTTPRequestRedirectFilter instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withHostname(instance.getHostname()); 
    fluent.withPath(instance.getPath()); 
    fluent.withPort(instance.getPort()); 
    fluent.withScheme(instance.getScheme()); 
    fluent.withStatusCode(instance.getStatusCode()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public HTTPRequestRedirectFilterBuilder(HTTPRequestRedirectFilter instance) {
    this(instance,false);
  }
  public HTTPRequestRedirectFilterBuilder(HTTPRequestRedirectFilter instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withHostname(instance.getHostname()); 
    this.withPath(instance.getPath()); 
    this.withPort(instance.getPort()); 
    this.withScheme(instance.getScheme()); 
    this.withStatusCode(instance.getStatusCode()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  HTTPRequestRedirectFilterFluent<?> fluent;
  Boolean validationEnabled;
  public HTTPRequestRedirectFilter build() {
    HTTPRequestRedirectFilter buildable = new HTTPRequestRedirectFilter(fluent.getHostname(),fluent.getPath(),fluent.getPort(),fluent.getScheme(),fluent.getStatusCode());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}