package io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GatewaySpecBuilder extends GatewaySpecFluentImpl<GatewaySpecBuilder> implements VisitableBuilder<GatewaySpec,GatewaySpecBuilder>{
  public GatewaySpecBuilder() {
    this(false);
  }
  public GatewaySpecBuilder(Boolean validationEnabled) {
    this(new GatewaySpec(), validationEnabled);
  }
  public GatewaySpecBuilder(GatewaySpecFluent<?> fluent) {
    this(fluent, false);
  }
  public GatewaySpecBuilder(GatewaySpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new GatewaySpec(), validationEnabled);
  }
  public GatewaySpecBuilder(GatewaySpecFluent<?> fluent,GatewaySpec instance) {
    this(fluent, instance, false);
  }
  public GatewaySpecBuilder(GatewaySpecFluent<?> fluent,GatewaySpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAddresses(instance.getAddresses()); 
    fluent.withGatewayClassName(instance.getGatewayClassName()); 
    fluent.withListeners(instance.getListeners()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public GatewaySpecBuilder(GatewaySpec instance) {
    this(instance,false);
  }
  public GatewaySpecBuilder(GatewaySpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAddresses(instance.getAddresses()); 
    this.withGatewayClassName(instance.getGatewayClassName()); 
    this.withListeners(instance.getListeners()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  GatewaySpecFluent<?> fluent;
  Boolean validationEnabled;
  public GatewaySpec build() {
    GatewaySpec buildable = new GatewaySpec(fluent.getAddresses(),fluent.getGatewayClassName(),fluent.getListeners());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}