package io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TCPRouteStatusBuilder extends TCPRouteStatusFluentImpl<TCPRouteStatusBuilder> implements VisitableBuilder<TCPRouteStatus,TCPRouteStatusBuilder>{
  public TCPRouteStatusBuilder() {
    this(false);
  }
  public TCPRouteStatusBuilder(Boolean validationEnabled) {
    this(new TCPRouteStatus(), validationEnabled);
  }
  public TCPRouteStatusBuilder(TCPRouteStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public TCPRouteStatusBuilder(TCPRouteStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TCPRouteStatus(), validationEnabled);
  }
  public TCPRouteStatusBuilder(TCPRouteStatusFluent<?> fluent,TCPRouteStatus instance) {
    this(fluent, instance, false);
  }
  public TCPRouteStatusBuilder(TCPRouteStatusFluent<?> fluent,TCPRouteStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withParents(instance.getParents()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public TCPRouteStatusBuilder(TCPRouteStatus instance) {
    this(instance,false);
  }
  public TCPRouteStatusBuilder(TCPRouteStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withParents(instance.getParents()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  TCPRouteStatusFluent<?> fluent;
  Boolean validationEnabled;
  public TCPRouteStatus build() {
    TCPRouteStatus buildable = new TCPRouteStatus(fluent.getParents());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}