package io.fabric8.kubernetes.api.model.gatewayapi.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HTTPBackendRefBuilder extends HTTPBackendRefFluentImpl<HTTPBackendRefBuilder> implements VisitableBuilder<HTTPBackendRef,HTTPBackendRefBuilder>{
  public HTTPBackendRefBuilder() {
    this(false);
  }
  public HTTPBackendRefBuilder(Boolean validationEnabled) {
    this(new HTTPBackendRef(), validationEnabled);
  }
  public HTTPBackendRefBuilder(HTTPBackendRefFluent<?> fluent) {
    this(fluent, false);
  }
  public HTTPBackendRefBuilder(HTTPBackendRefFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HTTPBackendRef(), validationEnabled);
  }
  public HTTPBackendRefBuilder(HTTPBackendRefFluent<?> fluent,HTTPBackendRef instance) {
    this(fluent, instance, false);
  }
  public HTTPBackendRefBuilder(HTTPBackendRefFluent<?> fluent,HTTPBackendRef instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withFilters(instance.getFilters()); 
    fluent.withGroup(instance.getGroup()); 
    fluent.withKind(instance.getKind()); 
    fluent.withName(instance.getName()); 
    fluent.withNamespace(instance.getNamespace()); 
    fluent.withPort(instance.getPort()); 
    fluent.withWeight(instance.getWeight()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public HTTPBackendRefBuilder(HTTPBackendRef instance) {
    this(instance,false);
  }
  public HTTPBackendRefBuilder(HTTPBackendRef instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withFilters(instance.getFilters()); 
    this.withGroup(instance.getGroup()); 
    this.withKind(instance.getKind()); 
    this.withName(instance.getName()); 
    this.withNamespace(instance.getNamespace()); 
    this.withPort(instance.getPort()); 
    this.withWeight(instance.getWeight()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  HTTPBackendRefFluent<?> fluent;
  Boolean validationEnabled;
  public HTTPBackendRef build() {
    HTTPBackendRef buildable = new HTTPBackendRef(fluent.getFilters(),fluent.getGroup(),fluent.getKind(),fluent.getName(),fluent.getNamespace(),fluent.getPort(),fluent.getWeight());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}