package io.fabric8.kubernetes.api.model.gatewayapi.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class BackendRefBuilder extends BackendRefFluentImpl<BackendRefBuilder> implements VisitableBuilder<BackendRef,BackendRefBuilder>{
  public BackendRefBuilder() {
    this(false);
  }
  public BackendRefBuilder(Boolean validationEnabled) {
    this(new BackendRef(), validationEnabled);
  }
  public BackendRefBuilder(BackendRefFluent<?> fluent) {
    this(fluent, false);
  }
  public BackendRefBuilder(BackendRefFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new BackendRef(), validationEnabled);
  }
  public BackendRefBuilder(BackendRefFluent<?> fluent,BackendRef instance) {
    this(fluent, instance, false);
  }
  public BackendRefBuilder(BackendRefFluent<?> fluent,BackendRef instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withGroup(instance.getGroup()); 
    fluent.withKind(instance.getKind()); 
    fluent.withName(instance.getName()); 
    fluent.withNamespace(instance.getNamespace()); 
    fluent.withPort(instance.getPort()); 
    fluent.withWeight(instance.getWeight()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public BackendRefBuilder(BackendRef instance) {
    this(instance,false);
  }
  public BackendRefBuilder(BackendRef instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withGroup(instance.getGroup()); 
    this.withKind(instance.getKind()); 
    this.withName(instance.getName()); 
    this.withNamespace(instance.getNamespace()); 
    this.withPort(instance.getPort()); 
    this.withWeight(instance.getWeight()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  BackendRefFluent<?> fluent;
  Boolean validationEnabled;
  public BackendRef build() {
    BackendRef buildable = new BackendRef(fluent.getGroup(),fluent.getKind(),fluent.getName(),fluent.getNamespace(),fluent.getPort(),fluent.getWeight());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}