package io.fabric8.kubernetes.api.model.gatewayapi.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ReferenceGrantToBuilder extends ReferenceGrantToFluentImpl<ReferenceGrantToBuilder> implements VisitableBuilder<ReferenceGrantTo,ReferenceGrantToBuilder>{
  public ReferenceGrantToBuilder() {
    this(false);
  }
  public ReferenceGrantToBuilder(Boolean validationEnabled) {
    this(new ReferenceGrantTo(), validationEnabled);
  }
  public ReferenceGrantToBuilder(ReferenceGrantToFluent<?> fluent) {
    this(fluent, false);
  }
  public ReferenceGrantToBuilder(ReferenceGrantToFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ReferenceGrantTo(), validationEnabled);
  }
  public ReferenceGrantToBuilder(ReferenceGrantToFluent<?> fluent,ReferenceGrantTo instance) {
    this(fluent, instance, false);
  }
  public ReferenceGrantToBuilder(ReferenceGrantToFluent<?> fluent,ReferenceGrantTo instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withGroup(instance.getGroup()); 
    fluent.withKind(instance.getKind()); 
    fluent.withName(instance.getName()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ReferenceGrantToBuilder(ReferenceGrantTo instance) {
    this(instance,false);
  }
  public ReferenceGrantToBuilder(ReferenceGrantTo instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withGroup(instance.getGroup()); 
    this.withKind(instance.getKind()); 
    this.withName(instance.getName()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ReferenceGrantToFluent<?> fluent;
  Boolean validationEnabled;
  public ReferenceGrantTo build() {
    ReferenceGrantTo buildable = new ReferenceGrantTo(fluent.getGroup(),fluent.getKind(),fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}