package io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HTTPRouteBuilder extends HTTPRouteFluentImpl<HTTPRouteBuilder> implements VisitableBuilder<HTTPRoute,HTTPRouteBuilder>{
  public HTTPRouteBuilder() {
    this(false);
  }
  public HTTPRouteBuilder(Boolean validationEnabled) {
    this(new HTTPRoute(), validationEnabled);
  }
  public HTTPRouteBuilder(HTTPRouteFluent<?> fluent) {
    this(fluent, false);
  }
  public HTTPRouteBuilder(HTTPRouteFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HTTPRoute(), validationEnabled);
  }
  public HTTPRouteBuilder(HTTPRouteFluent<?> fluent,HTTPRoute instance) {
    this(fluent, instance, false);
  }
  public HTTPRouteBuilder(HTTPRouteFluent<?> fluent,HTTPRoute instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public HTTPRouteBuilder(HTTPRoute instance) {
    this(instance,false);
  }
  public HTTPRouteBuilder(HTTPRoute instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  HTTPRouteFluent<?> fluent;
  Boolean validationEnabled;
  public HTTPRoute build() {
    HTTPRoute buildable = new HTTPRoute(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}