package io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.ParentReference;
import io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.ParentReferenceBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.ParentReferenceFluentImpl;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class TCPRouteSpecFluentImpl<A extends TCPRouteSpecFluent<A>> extends BaseFluent<A> implements TCPRouteSpecFluent<A>{
  public TCPRouteSpecFluentImpl() {
  }
  public TCPRouteSpecFluentImpl(TCPRouteSpec instance) {
    if (instance != null) {
      this.withParentRefs(instance.getParentRefs());
      this.withRules(instance.getRules());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private ArrayList<ParentReferenceBuilder> parentRefs = new ArrayList<ParentReferenceBuilder>();
  private ArrayList<TCPRouteRuleBuilder> rules = new ArrayList<TCPRouteRuleBuilder>();
  private Map<String,Object> additionalProperties;
  public A addToParentRefs(int index,ParentReference item) {
    if (this.parentRefs == null) {this.parentRefs = new ArrayList<ParentReferenceBuilder>();}
    ParentReferenceBuilder builder = new ParentReferenceBuilder(item);
    if (index < 0 || index >= parentRefs.size()) { _visitables.get("parentRefs").add(builder); parentRefs.add(builder); } else { _visitables.get("parentRefs").add(index, builder); parentRefs.add(index, builder);}
    return (A)this;
  }
  public A setToParentRefs(int index,ParentReference item) {
    if (this.parentRefs == null) {this.parentRefs = new ArrayList<ParentReferenceBuilder>();}
    ParentReferenceBuilder builder = new ParentReferenceBuilder(item);
    if (index < 0 || index >= parentRefs.size()) { _visitables.get("parentRefs").add(builder); parentRefs.add(builder); } else { _visitables.get("parentRefs").set(index, builder); parentRefs.set(index, builder);}
    return (A)this;
  }
  public A addToParentRefs(io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.ParentReference... items) {
    if (this.parentRefs == null) {this.parentRefs = new ArrayList<ParentReferenceBuilder>();}
    for (ParentReference item : items) {ParentReferenceBuilder builder = new ParentReferenceBuilder(item);_visitables.get("parentRefs").add(builder);this.parentRefs.add(builder);} return (A)this;
  }
  public A addAllToParentRefs(Collection<ParentReference> items) {
    if (this.parentRefs == null) {this.parentRefs = new ArrayList<ParentReferenceBuilder>();}
    for (ParentReference item : items) {ParentReferenceBuilder builder = new ParentReferenceBuilder(item);_visitables.get("parentRefs").add(builder);this.parentRefs.add(builder);} return (A)this;
  }
  public A removeFromParentRefs(io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.ParentReference... items) {
    for (ParentReference item : items) {ParentReferenceBuilder builder = new ParentReferenceBuilder(item);_visitables.get("parentRefs").remove(builder);if (this.parentRefs != null) {this.parentRefs.remove(builder);}} return (A)this;
  }
  public A removeAllFromParentRefs(Collection<ParentReference> items) {
    for (ParentReference item : items) {ParentReferenceBuilder builder = new ParentReferenceBuilder(item);_visitables.get("parentRefs").remove(builder);if (this.parentRefs != null) {this.parentRefs.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromParentRefs(Predicate<ParentReferenceBuilder> predicate) {
    if (parentRefs == null) return (A) this;
    final Iterator<ParentReferenceBuilder> each = parentRefs.iterator();
    final List visitables = _visitables.get("parentRefs");
    while (each.hasNext()) {
      ParentReferenceBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildParentRefs instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ParentReference> getParentRefs() {
    return parentRefs != null ? build(parentRefs) : null;
  }
  public List<ParentReference> buildParentRefs() {
    return parentRefs != null ? build(parentRefs) : null;
  }
  public ParentReference buildParentRef(int index) {
    return this.parentRefs.get(index).build();
  }
  public ParentReference buildFirstParentRef() {
    return this.parentRefs.get(0).build();
  }
  public ParentReference buildLastParentRef() {
    return this.parentRefs.get(parentRefs.size() - 1).build();
  }
  public ParentReference buildMatchingParentRef(Predicate<ParentReferenceBuilder> predicate) {
    for (ParentReferenceBuilder item: parentRefs) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingParentRef(Predicate<ParentReferenceBuilder> predicate) {
    for (ParentReferenceBuilder item: parentRefs) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withParentRefs(List<ParentReference> parentRefs) {
    if (this.parentRefs != null) { _visitables.get("parentRefs").clear();}
    if (parentRefs != null) {this.parentRefs = new ArrayList(); for (ParentReference item : parentRefs){this.addToParentRefs(item);}} else { this.parentRefs = null;} return (A) this;
  }
  public A withParentRefs(io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.ParentReference... parentRefs) {
    if (this.parentRefs != null) {this.parentRefs.clear(); _visitables.remove("parentRefs"); }
    if (parentRefs != null) {for (ParentReference item :parentRefs){ this.addToParentRefs(item);}} return (A) this;
  }
  public Boolean hasParentRefs() {
    return parentRefs != null && !parentRefs.isEmpty();
  }
  public TCPRouteSpecFluentImpl.ParentRefsNested<A> addNewParentRef() {
    return new TCPRouteSpecFluentImpl.ParentRefsNestedImpl();
  }
  public TCPRouteSpecFluentImpl.ParentRefsNested<A> addNewParentRefLike(ParentReference item) {
    return new TCPRouteSpecFluentImpl.ParentRefsNestedImpl(-1, item);
  }
  public TCPRouteSpecFluentImpl.ParentRefsNested<A> setNewParentRefLike(int index,ParentReference item) {
    return new TCPRouteSpecFluentImpl.ParentRefsNestedImpl(index, item);
  }
  public TCPRouteSpecFluentImpl.ParentRefsNested<A> editParentRef(int index) {
    if (parentRefs.size() <= index) throw new RuntimeException("Can't edit parentRefs. Index exceeds size.");
    return setNewParentRefLike(index, buildParentRef(index));
  }
  public TCPRouteSpecFluentImpl.ParentRefsNested<A> editFirstParentRef() {
    if (parentRefs.size() == 0) throw new RuntimeException("Can't edit first parentRefs. The list is empty.");
    return setNewParentRefLike(0, buildParentRef(0));
  }
  public TCPRouteSpecFluentImpl.ParentRefsNested<A> editLastParentRef() {
    int index = parentRefs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last parentRefs. The list is empty.");
    return setNewParentRefLike(index, buildParentRef(index));
  }
  public TCPRouteSpecFluentImpl.ParentRefsNested<A> editMatchingParentRef(Predicate<ParentReferenceBuilder> predicate) {
    int index = -1;
    for (int i=0;i<parentRefs.size();i++) { 
    if (predicate.test(parentRefs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching parentRefs. No match found.");
    return setNewParentRefLike(index, buildParentRef(index));
  }
  public A addToRules(int index,TCPRouteRule item) {
    if (this.rules == null) {this.rules = new ArrayList<TCPRouteRuleBuilder>();}
    TCPRouteRuleBuilder builder = new TCPRouteRuleBuilder(item);
    if (index < 0 || index >= rules.size()) { _visitables.get("rules").add(builder); rules.add(builder); } else { _visitables.get("rules").add(index, builder); rules.add(index, builder);}
    return (A)this;
  }
  public A setToRules(int index,TCPRouteRule item) {
    if (this.rules == null) {this.rules = new ArrayList<TCPRouteRuleBuilder>();}
    TCPRouteRuleBuilder builder = new TCPRouteRuleBuilder(item);
    if (index < 0 || index >= rules.size()) { _visitables.get("rules").add(builder); rules.add(builder); } else { _visitables.get("rules").set(index, builder); rules.set(index, builder);}
    return (A)this;
  }
  public A addToRules(io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.TCPRouteRule... items) {
    if (this.rules == null) {this.rules = new ArrayList<TCPRouteRuleBuilder>();}
    for (TCPRouteRule item : items) {TCPRouteRuleBuilder builder = new TCPRouteRuleBuilder(item);_visitables.get("rules").add(builder);this.rules.add(builder);} return (A)this;
  }
  public A addAllToRules(Collection<TCPRouteRule> items) {
    if (this.rules == null) {this.rules = new ArrayList<TCPRouteRuleBuilder>();}
    for (TCPRouteRule item : items) {TCPRouteRuleBuilder builder = new TCPRouteRuleBuilder(item);_visitables.get("rules").add(builder);this.rules.add(builder);} return (A)this;
  }
  public A removeFromRules(io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.TCPRouteRule... items) {
    for (TCPRouteRule item : items) {TCPRouteRuleBuilder builder = new TCPRouteRuleBuilder(item);_visitables.get("rules").remove(builder);if (this.rules != null) {this.rules.remove(builder);}} return (A)this;
  }
  public A removeAllFromRules(Collection<TCPRouteRule> items) {
    for (TCPRouteRule item : items) {TCPRouteRuleBuilder builder = new TCPRouteRuleBuilder(item);_visitables.get("rules").remove(builder);if (this.rules != null) {this.rules.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromRules(Predicate<TCPRouteRuleBuilder> predicate) {
    if (rules == null) return (A) this;
    final Iterator<TCPRouteRuleBuilder> each = rules.iterator();
    final List visitables = _visitables.get("rules");
    while (each.hasNext()) {
      TCPRouteRuleBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildRules instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<TCPRouteRule> getRules() {
    return rules != null ? build(rules) : null;
  }
  public List<TCPRouteRule> buildRules() {
    return rules != null ? build(rules) : null;
  }
  public TCPRouteRule buildRule(int index) {
    return this.rules.get(index).build();
  }
  public TCPRouteRule buildFirstRule() {
    return this.rules.get(0).build();
  }
  public TCPRouteRule buildLastRule() {
    return this.rules.get(rules.size() - 1).build();
  }
  public TCPRouteRule buildMatchingRule(Predicate<TCPRouteRuleBuilder> predicate) {
    for (TCPRouteRuleBuilder item: rules) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingRule(Predicate<TCPRouteRuleBuilder> predicate) {
    for (TCPRouteRuleBuilder item: rules) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withRules(List<TCPRouteRule> rules) {
    if (this.rules != null) { _visitables.get("rules").clear();}
    if (rules != null) {this.rules = new ArrayList(); for (TCPRouteRule item : rules){this.addToRules(item);}} else { this.rules = null;} return (A) this;
  }
  public A withRules(io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.TCPRouteRule... rules) {
    if (this.rules != null) {this.rules.clear(); _visitables.remove("rules"); }
    if (rules != null) {for (TCPRouteRule item :rules){ this.addToRules(item);}} return (A) this;
  }
  public Boolean hasRules() {
    return rules != null && !rules.isEmpty();
  }
  public TCPRouteSpecFluentImpl.RulesNested<A> addNewRule() {
    return new TCPRouteSpecFluentImpl.RulesNestedImpl();
  }
  public TCPRouteSpecFluentImpl.RulesNested<A> addNewRuleLike(TCPRouteRule item) {
    return new TCPRouteSpecFluentImpl.RulesNestedImpl(-1, item);
  }
  public TCPRouteSpecFluentImpl.RulesNested<A> setNewRuleLike(int index,TCPRouteRule item) {
    return new TCPRouteSpecFluentImpl.RulesNestedImpl(index, item);
  }
  public TCPRouteSpecFluentImpl.RulesNested<A> editRule(int index) {
    if (rules.size() <= index) throw new RuntimeException("Can't edit rules. Index exceeds size.");
    return setNewRuleLike(index, buildRule(index));
  }
  public TCPRouteSpecFluentImpl.RulesNested<A> editFirstRule() {
    if (rules.size() == 0) throw new RuntimeException("Can't edit first rules. The list is empty.");
    return setNewRuleLike(0, buildRule(0));
  }
  public TCPRouteSpecFluentImpl.RulesNested<A> editLastRule() {
    int index = rules.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last rules. The list is empty.");
    return setNewRuleLike(index, buildRule(index));
  }
  public TCPRouteSpecFluentImpl.RulesNested<A> editMatchingRule(Predicate<TCPRouteRuleBuilder> predicate) {
    int index = -1;
    for (int i=0;i<rules.size();i++) { 
    if (predicate.test(rules.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching rules. No match found.");
    return setNewRuleLike(index, buildRule(index));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    TCPRouteSpecFluentImpl that = (TCPRouteSpecFluentImpl) o;
    if (!java.util.Objects.equals(parentRefs, that.parentRefs)) return false;

    if (!java.util.Objects.equals(rules, that.rules)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(parentRefs,  rules,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (parentRefs != null) { sb.append("parentRefs:"); sb.append(parentRefs + ","); }
    if (rules != null) { sb.append("rules:"); sb.append(rules + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ParentRefsNestedImpl<N> extends ParentReferenceFluentImpl<TCPRouteSpecFluentImpl.ParentRefsNested<N>> implements TCPRouteSpecFluentImpl.ParentRefsNested<N>,Nested<N>{
    ParentRefsNestedImpl(int index,ParentReference item) {
      this.index = index;
      this.builder = new ParentReferenceBuilder(this, item);
    }
    ParentRefsNestedImpl() {
      this.index = -1;
      this.builder = new ParentReferenceBuilder(this);
    }
    ParentReferenceBuilder builder;
    int index;
    public N and() {
      return (N) TCPRouteSpecFluentImpl.this.setToParentRefs(index,builder.build());
    }
    public N endParentRef() {
      return and();
    }
    
  }
  class RulesNestedImpl<N> extends TCPRouteRuleFluentImpl<TCPRouteSpecFluentImpl.RulesNested<N>> implements TCPRouteSpecFluentImpl.RulesNested<N>,Nested<N>{
    RulesNestedImpl(int index,TCPRouteRule item) {
      this.index = index;
      this.builder = new TCPRouteRuleBuilder(this, item);
    }
    RulesNestedImpl() {
      this.index = -1;
      this.builder = new TCPRouteRuleBuilder(this);
    }
    TCPRouteRuleBuilder builder;
    int index;
    public N and() {
      return (N) TCPRouteSpecFluentImpl.this.setToRules(index,builder.build());
    }
    public N endRule() {
      return and();
    }
    
  }
  
}