package io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class UDPRouteStatusBuilder extends UDPRouteStatusFluentImpl<UDPRouteStatusBuilder> implements VisitableBuilder<UDPRouteStatus,UDPRouteStatusBuilder>{
  public UDPRouteStatusBuilder() {
    this(false);
  }
  public UDPRouteStatusBuilder(Boolean validationEnabled) {
    this(new UDPRouteStatus(), validationEnabled);
  }
  public UDPRouteStatusBuilder(UDPRouteStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public UDPRouteStatusBuilder(UDPRouteStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new UDPRouteStatus(), validationEnabled);
  }
  public UDPRouteStatusBuilder(UDPRouteStatusFluent<?> fluent,UDPRouteStatus instance) {
    this(fluent, instance, false);
  }
  public UDPRouteStatusBuilder(UDPRouteStatusFluent<?> fluent,UDPRouteStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withParents(instance.getParents());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public UDPRouteStatusBuilder(UDPRouteStatus instance) {
    this(instance,false);
  }
  public UDPRouteStatusBuilder(UDPRouteStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withParents(instance.getParents());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  UDPRouteStatusFluent<?> fluent;
  Boolean validationEnabled;
  public UDPRouteStatus build() {
    UDPRouteStatus buildable = new UDPRouteStatus(fluent.getParents());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}