package io.fabric8.kubernetes.api.model.gatewayapi.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RouteParentStatusBuilder extends RouteParentStatusFluentImpl<RouteParentStatusBuilder> implements VisitableBuilder<RouteParentStatus,RouteParentStatusBuilder>{
  public RouteParentStatusBuilder() {
    this(false);
  }
  public RouteParentStatusBuilder(Boolean validationEnabled) {
    this(new RouteParentStatus(), validationEnabled);
  }
  public RouteParentStatusBuilder(RouteParentStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public RouteParentStatusBuilder(RouteParentStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new RouteParentStatus(), validationEnabled);
  }
  public RouteParentStatusBuilder(RouteParentStatusFluent<?> fluent,RouteParentStatus instance) {
    this(fluent, instance, false);
  }
  public RouteParentStatusBuilder(RouteParentStatusFluent<?> fluent,RouteParentStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withConditions(instance.getConditions());
      fluent.withControllerName(instance.getControllerName());
      fluent.withParentRef(instance.getParentRef());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public RouteParentStatusBuilder(RouteParentStatus instance) {
    this(instance,false);
  }
  public RouteParentStatusBuilder(RouteParentStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withConditions(instance.getConditions());
      this.withControllerName(instance.getControllerName());
      this.withParentRef(instance.getParentRef());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  RouteParentStatusFluent<?> fluent;
  Boolean validationEnabled;
  public RouteParentStatus build() {
    RouteParentStatus buildable = new RouteParentStatus(fluent.getConditions(),fluent.getControllerName(),fluent.getParentRef());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}