package io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GRPCRouteListBuilder extends GRPCRouteListFluent<GRPCRouteListBuilder> implements VisitableBuilder<GRPCRouteList,GRPCRouteListBuilder>{
  public GRPCRouteListBuilder() {
    this(false);
  }
  public GRPCRouteListBuilder(Boolean validationEnabled) {
    this(new GRPCRouteList(), validationEnabled);
  }
  public GRPCRouteListBuilder(GRPCRouteListFluent<?> fluent) {
    this(fluent, false);
  }
  public GRPCRouteListBuilder(GRPCRouteListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new GRPCRouteList(), validationEnabled);
  }
  public GRPCRouteListBuilder(GRPCRouteListFluent<?> fluent,GRPCRouteList instance) {
    this(fluent, instance, false);
  }
  public GRPCRouteListBuilder(GRPCRouteListFluent<?> fluent,GRPCRouteList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new GRPCRouteList());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public GRPCRouteListBuilder(GRPCRouteList instance) {
    this(instance,false);
  }
  public GRPCRouteListBuilder(GRPCRouteList instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new GRPCRouteList());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  GRPCRouteListFluent<?> fluent;
  Boolean validationEnabled;
  public GRPCRouteList build() {
    GRPCRouteList buildable = new GRPCRouteList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}