package io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GatewayClassBuilder extends GatewayClassFluent<GatewayClassBuilder> implements VisitableBuilder<GatewayClass,GatewayClassBuilder>{
  public GatewayClassBuilder() {
    this(false);
  }
  public GatewayClassBuilder(Boolean validationEnabled) {
    this(new GatewayClass(), validationEnabled);
  }
  public GatewayClassBuilder(GatewayClassFluent<?> fluent) {
    this(fluent, false);
  }
  public GatewayClassBuilder(GatewayClassFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new GatewayClass(), validationEnabled);
  }
  public GatewayClassBuilder(GatewayClassFluent<?> fluent,GatewayClass instance) {
    this(fluent, instance, false);
  }
  public GatewayClassBuilder(GatewayClassFluent<?> fluent,GatewayClass instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new GatewayClass());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public GatewayClassBuilder(GatewayClass instance) {
    this(instance,false);
  }
  public GatewayClassBuilder(GatewayClass instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new GatewayClass());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  GatewayClassFluent<?> fluent;
  Boolean validationEnabled;
  public GatewayClass build() {
    GatewayClass buildable = new GatewayClass(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}