package io.fabric8.kubernetes.api.model.gatewayapi.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class BackendObjectReferenceBuilder extends BackendObjectReferenceFluent<BackendObjectReferenceBuilder> implements VisitableBuilder<BackendObjectReference,BackendObjectReferenceBuilder>{
  public BackendObjectReferenceBuilder() {
    this(false);
  }
  public BackendObjectReferenceBuilder(Boolean validationEnabled) {
    this(new BackendObjectReference(), validationEnabled);
  }
  public BackendObjectReferenceBuilder(BackendObjectReferenceFluent<?> fluent) {
    this(fluent, false);
  }
  public BackendObjectReferenceBuilder(BackendObjectReferenceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new BackendObjectReference(), validationEnabled);
  }
  public BackendObjectReferenceBuilder(BackendObjectReferenceFluent<?> fluent,BackendObjectReference instance) {
    this(fluent, instance, false);
  }
  public BackendObjectReferenceBuilder(BackendObjectReferenceFluent<?> fluent,BackendObjectReference instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new BackendObjectReference());

    if (instance != null) {
      fluent.withGroup(instance.getGroup());
      fluent.withKind(instance.getKind());
      fluent.withName(instance.getName());
      fluent.withNamespace(instance.getNamespace());
      fluent.withPort(instance.getPort());
      fluent.withGroup(instance.getGroup());
      fluent.withKind(instance.getKind());
      fluent.withName(instance.getName());
      fluent.withNamespace(instance.getNamespace());
      fluent.withPort(instance.getPort());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public BackendObjectReferenceBuilder(BackendObjectReference instance) {
    this(instance,false);
  }
  public BackendObjectReferenceBuilder(BackendObjectReference instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new BackendObjectReference());

    if (instance != null) {
      this.withGroup(instance.getGroup());
      this.withKind(instance.getKind());
      this.withName(instance.getName());
      this.withNamespace(instance.getNamespace());
      this.withPort(instance.getPort());
      this.withGroup(instance.getGroup());
      this.withKind(instance.getKind());
      this.withName(instance.getName());
      this.withNamespace(instance.getNamespace());
      this.withPort(instance.getPort());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  BackendObjectReferenceFluent<?> fluent;
  Boolean validationEnabled;
  public BackendObjectReference build() {
    BackendObjectReference buildable = new BackendObjectReference(fluent.getGroup(),fluent.getKind(),fluent.getName(),fluent.getNamespace(),fluent.getPort());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}